/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.pMW;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$2;
import com.bitwig.flt.control_surface.proxy.ClipProxy$3;
import com.bitwig.flt.control_surface.proxy.ClipProxy$4;
import com.bitwig.flt.control_surface.proxy.ClipProxy$5;
import com.bitwig.flt.control_surface.proxy.ClipProxy$Step;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.NoteLaneProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.document.core.iface.vt2;
import com.bitwig.ramona.core.EKu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private tNG mPlaybackPositionListener = new ClipProxy$3(this);
    private EKu mHierarchyListener = new ClipProxy$4(this);
    private XAD mSelectionChangeListener = new ClipProxy$5(this);
    private HBb mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private List mSteps;
    private int mBaseKey;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private NoteLaneProxy[] mNoteLanes;
    private final ListValueBankItemTargetUpdater mNoteLanesBankUpdater;
    private SettableBooleanValueProxy mShuffle;
    private RangedValueProxy mAccent;
    private SettableBooleanValueProxy mIsLoopEnabled;
    private BeatTimeProxy mPlayStart;
    private BeatTimeProxy mPlayStop;
    private BeatTimeProxy mLoopStart;
    private BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private Timer mUpdateStepGridTimer;
    private final TrackProxy mTrackSection;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList(2);

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n4) {
        super(controlSurfaceObject);
        int n5;
        this.setKey(string);
        this.mGridHeight = n4;
        this.mGridWidth = n2;
        this.mBaseKey = 0;
        this.mStepGrid = new n2H(this.mStepSize);
        this.mSteps = new ArrayList(this.mGridHeight * this.mGridWidth);
        for (n5 = 0; n5 < n4; ++n5) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mSteps.add(new ClipProxy$Step(this, i2, n5));
            }
        }
        if (this.mGridHeight > 0) {
            this.mNoteLanes = new NoteLaneProxy[this.mGridHeight];
            for (n5 = 0; n5 < this.mGridHeight; ++n5) {
                NoteLaneProxy noteLaneProxy;
                String string2 = string + "/NoteLane" + n5;
                this.mNoteLanes[n5] = noteLaneProxy = new NoteLaneProxy(this, string2, n5);
                this.addChild(noteLaneProxy);
            }
            this.mNoteLanesBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mNoteLanes);
        } else {
            this.mNoteLanes = null;
            this.mNoteLanesBankUpdater = null;
        }
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackSection = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
    }

    @Override
    public Class getTargetType() {
        return bvf.class;
    }

    protected vt2 getDocumentFromTarget(bvf bvf2) {
        return bvf2.f2p();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        this.scrollToKey(Math.max(128 - this.mGridHeight, this.mBaseKey + this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        this.scrollToKey(Math.min(0, this.mBaseKey - this.mGridHeight));
    }

    @Override
    public void scrollKeysStepUp() {
        this.scrollToKey(Math.max(128 - this.mGridHeight, this.mBaseKey + 1));
    }

    @Override
    public void scrollKeysStepDown() {
        this.scrollToKey(Math.min(0, this.mBaseKey - 1));
    }

    @Override
    public void scrollToKey(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToKey(n2));
    }

    private void doScrollToKey(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null && this.mBaseKey != n2) {
            this.mBaseKey = n2;
            this.updateGrid();
        }
    }

    @Override
    public void scrollToStep(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n2));
    }

    private void doScrollToStep(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null && this.mBaseStep != n2) {
            this.mBaseStep = n2;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null && bvf2.sYU() != null) {
            bvf2.sYU().Gnn(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.scrollToStep(this.mBaseStep + this.mGridWidth);
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.scrollToStep(this.mBaseStep - this.mGridWidth);
    }

    @Override
    public void scrollStepsStepForward() {
        this.scrollToStep(this.mBaseStep + 1);
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.scrollToStep(this.mBaseStep - 1);
    }

    @Override
    public void toggleStep(int n2, int n4, int n5) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doToggleStep(n2, n4, n5));
    }

    private void doToggleStep(int n2, int n4, int n5) {
        assert (cNz.DmN(this.isDocumentThread()));
        brZ brZ2 = this.getClip();
        if (brZ2 == null) {
            return;
        }
        bvf bvf2 = (bvf)this.getTarget();
        assert (cNz.DmN(bvf2 != null));
        int n6 = n4 + this.mBaseKey;
        double d3 = this.getTimeForCell(n2);
        double d4 = d3 + this.getStepSize() - 1.0E-4;
        if (n6 >= 0 && n6 < 128) {
            k3Y k3Y2 = brZ2.DmN().Gnn(n6, false);
            List list = k3Y2 != null ? k3Y2.DmN(d3, d4) : Collections.EMPTY_LIST;
            bvf2.RFf().Mei();
            if (list.isEmpty()) {
                brZ2.Gnn(d3, this.mStepSize, n6, (float)n5 * 0.007874016f, bvf2.RFf().pQJ());
            } else {
                for (CP cP2 : list) {
                    k3Y2.Gqs(cP2);
                }
            }
        }
    }

    @Override
    public void setStep(int n2, int n4, int n5, double d3) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetStep(n2, n4, n5, d3));
    }

    private void doSetStep(int n2, int n4, int n5, double d3) {
        assert (cNz.DmN(this.isDocumentThread()));
        brZ brZ2 = this.getClip();
        if (brZ2 == null) {
            return;
        }
        bvf bvf2 = (bvf)this.getTarget();
        assert (cNz.DmN(bvf2 != null));
        int n6 = n4 + this.mBaseKey;
        double d4 = this.getTimeForCell(n2);
        if (n6 >= 0 && n6 < 128) {
            brZ2.Gnn(d4, d3, n6, (float)n5 * 0.007874016f, bvf2.RFf().pQJ());
        }
    }

    @Override
    public void clearStep(int n2, int n4) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doClearStep(n2, n4));
    }

    private void doClearStep(int n2, int n4) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            brZ brZ2 = this.getClip();
            if (brZ2 == null) {
                return;
            }
            int n5 = n4 + this.mBaseKey;
            double d3 = this.getTimeForCell(n2);
            double d4 = d3 + this.getStepSize() - 1.0E-4;
            if (n5 >= 0 && n5 < 128) {
                k3Y k3Y2 = brZ2.DmN().Gnn(n5, false);
                if (k3Y2 != null) {
                    List list = k3Y2.DmN(d3, d4);
                    for (GnV gnV : list) {
                        k3Y2.Gqs(gnV);
                    }
                }
                bvf2.RFf().Mei();
            }
        }
    }

    @Override
    public void clearSteps() {
        this.exec(() -> this.doClearSteps());
    }

    private void doClearSteps() {
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            brZ brZ2 = this.getClip();
            if (brZ2 == null) {
                return;
            }
            brZ2.Gqs().qpf(-1.7976931348623157E308, Double.MAX_VALUE);
            bvf2.RFf().Mei();
        }
    }

    @Override
    public void clearSteps(int n2) {
        this.exec(() -> this.doClearSteps(n2));
    }

    private void doClearSteps(int n2) {
        assert (cNz.qpf(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            k3Y k3Y2;
            brZ brZ2 = this.getClip();
            if (brZ2 == null) {
                return;
            }
            int n4 = n2 + this.mBaseKey;
            if (n4 >= 0 && n4 < 128 && (k3Y2 = brZ2.DmN().Gnn(n4, false)) != null) {
                k3Y2.Ed1();
            }
        }
    }

    @Override
    public void selectStepContents(int n2, int n4, boolean bl2) {
        this.exec(() -> this.doSelectStepContents(n2, n4, bl2));
    }

    private void doSelectStepContents(int n2, int n4, boolean bl2) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            brZ brZ2 = this.getClip();
            if (brZ2 == null) {
                return;
            }
            int n5 = n4 + this.mBaseKey;
            double d3 = this.getTimeForCell(n2);
            double d4 = d3 + this.getStepSize() - 1.0E-4;
            if (n5 >= 0 && n5 < 128) {
                k3Y k3Y2 = brZ2.DmN().Gnn(n5, false);
                List list = k3Y2 != null ? k3Y2.DmN(d3, d4) : Collections.EMPTY_LIST;
                bcM bcM2 = bvf2.RFf();
                if (bl2) {
                    bcM2.Mei();
                }
                for (N1K n1K : list) {
                    bcM2.Wcd(n1K.Gnn(0, false));
                }
            }
        }
    }

    @Override
    public void setStepSize(double d3) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (d3 <= 0.0) {
            throw new wJp("step size must be > 0");
        }
        this.exec(() -> this.doSetStepSize(d3));
    }

    private void doSetStepSize(double d3) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (this.mStepSize != d3) {
            this.mStepSize = d3;
            this.mStepGrid = new n2H(this.mStepSize);
            if (!this.mHasInvalidatedGrid && bvf2 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateStepGridTimer != null) {
                    this.mUpdateStepGridTimer.cancel();
                }
                this.mUpdateStepGridTimer = new Timer("Update Step Grid");
                this.mUpdateStepGridTimer.schedule((TimerTask)new ClipProxy$1(this), 100L);
            }
        }
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n2) {
        return (double)(this.mBaseStep + n2) * this.getStepSize();
    }

    private int getKeyForY(int n2) {
        return this.mBaseKey + n2;
    }

    private brZ getClip() {
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null && bvf2.sYU() instanceof brZ) {
            return (brZ)bvf2.sYU();
        }
        return null;
    }

    private void invalidateGrid() {
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            pMW.QOM().DmN(new ClipProxy$2(this));
        }
    }

    private void updateGrid() {
        assert (cNz.DmN(this.isDocumentThread()));
        brZ brZ2 = this.getClip();
        bvf bvf2 = (bvf)this.getTarget();
        for (int i2 = 0; i2 < this.mGridWidth; ++i2) {
            double d3 = this.getTimeForCell(i2);
            double d4 = d3 + this.getStepSize() - 1.0E-4;
            List list = Collections.emptyList();
            if (brZ2 != null) {
                assert (cNz.qpf(brZ2.zQX().q_()));
                list = TLy.Gnn(brZ2.DmN().Wcd(), d3, d4);
            }
            for (int i3 = 0; i3 < this.mGridHeight; ++i3) {
                ClipProxy$Step clipProxy$Step = (ClipProxy$Step)this.mSteps.get(i2 + i3 * this.mGridWidth);
                int n2 = this.getKeyForY(i3);
                int n4 = 0;
                boolean bl2 = false;
                for (CP cP2 : list) {
                    GnV gnV = (GnV)cP2;
                    if (gnV.Gqs() != n2) continue;
                    int n5 = n4 = gnV.sFn() >= d3 ? 2 : 1;
                    if (!bvf2.RFf().Gnn(gnV)) continue;
                    bl2 = true;
                }
                clipProxy$Step.setNoteState(n4);
                clipProxy$Step.setHasSelectedNote(bl2);
            }
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (cNz.DmN(this.isDocumentThread()));
        vt2 vt22 = this.getDocument();
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null && vt22 != null) {
            RCm rCm = bvf2.sYU();
            sRI sRI2 = (sRI)rCm.qpf(sRI.class);
            if (sRI2 != null) {
                kpx kpx2 = vt22.BEq().DmN();
                kpx2.jtS(sRI2);
                kpx2.zUg();
                if (kpx2.Exo()) {
                    kpx2.MC3();
                }
            }
            rCm.yN3();
        }
    }

    @Override
    public void duplicateContent() {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            bvf2.sYU().yN3();
        }
    }

    @Override
    public void transpose(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n2));
    }

    private void doTranspose(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            bvf2.sYU().Gnn(n2);
        }
    }

    @Override
    public void quantize(double d3) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (d3 <= 0.0 || d3 > 1.0) {
            throw new wJp("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d3));
    }

    private void doQuantize(double d3) {
        assert (cNz.DmN(this.isDocumentThread()));
        bvf bvf2 = (bvf)this.getTarget();
        if (bvf2 != null) {
            bvf2.Gnn(d3, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackSection;
    }

    protected void connectToTarget(bvf bvf2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(bvf2 != null));
        RCm rCm = bvf2.sYU();
        u1y u1y2 = rCm.QOM();
        brZ brZ2 = this.getClip();
        if (brZ2 != null) {
            brZ2.Gqs().DmN(this.mPlaybackPositionListener);
            brZ2.ZMi().Gnn(this.mHierarchyListener);
        }
        bvf2.RFf().XIv().Gnn(this.mSelectionChangeListener);
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.setTarget(rCm.kcS().dTJ());
        }
        this.updateGrid();
        this.mShuffle.setTarget(u1y2.pg_());
        this.mAccent.setTarget(u1y2.kcS());
        EGH eGH = u1y2.jtS();
        this.mPlayStart.setTarget(eGH.bo_().sYU());
        this.mPlayStop.setTarget(eGH.Gqs().sYU());
        this.mIsLoopEnabled.setTarget(eGH.nfh());
        this.mLoopStart.setTarget(eGH.jtS().sYU());
        this.mLoopLength.setTarget(eGH.jtS().ZHQ());
        this.mColor.setTarget(rCm.Ed1());
        this.mColor.setEditableValue(rCm.QeX());
        if (this.mTrackSection != null) {
            sRI sRI2;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackSection.getClipLauncherSlots();
            fCQ fCQ2 = rCm.ePI();
            this.mTrackSection.setTarget(fCQ2);
            if (clipLauncherSlotBankProxy != null && (sRI2 = (sRI)rCm.qpf(sRI.class)) != null) {
                clipLauncherSlotBankProxy.scrollToScene(sRI2);
            }
        }
        this.connectObservers(rCm);
    }

    protected void disconnectFromTarget(bvf bvf2) {
        assert (cNz.DmN(bvf2 != null));
        RCm rCm = bvf2.sYU();
        this.disconnectObservers(rCm);
        brZ brZ2 = this.getClip();
        if (this.mTrackSection != null) {
            this.mTrackSection.clearTarget();
        }
        if (brZ2 != null) {
            brZ2.Gqs().qpf(this.mPlaybackPositionListener);
            brZ2.ZMi().Gqs(this.mHierarchyListener);
        }
        u1y u1y2 = rCm.QOM();
        EGH eGH = u1y2.jtS();
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.clearTarget();
        }
        bvf2.RFf().XIv().Gqs(this.mSelectionChangeListener);
        this.updateGrid();
        this.setPlayingStep(-1);
    }

    private void sendNoteStateToObservers(int n2, int n4, int n5) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.queueCallback(() -> this.notifyStepDataObservers(n2, n4, n5));
    }

    private void notifyStepDataObservers(int n2, int n4, int n5) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        for (StepDataChangedCallback stepDataChangedCallback : this.mStepDataChangedCallbacks) {
            stepDataChangedCallback.stepStateChanged(n2, n4, n5);
        }
    }

    private void setPlayingStep(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(n2 >= -1));
        if (n2 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n2;
            this.mPlayingStep.setIntegerValue(n2);
        }
    }

    static /* synthetic */ void access$000(ClipProxy clipProxy) {
        clipProxy.updateGrid();
    }

    static /* synthetic */ boolean access$102(ClipProxy clipProxy, boolean bl2) {
        clipProxy.mHasInvalidatedGrid = bl2;
        return clipProxy.mHasInvalidatedGrid;
    }

    static /* synthetic */ Timer access$202(ClipProxy clipProxy, Timer timer) {
        clipProxy.mUpdateStepGridTimer = timer;
        return clipProxy.mUpdateStepGridTimer;
    }

    static /* synthetic */ void access$300(ClipProxy clipProxy, int n2, int n4, int n5) {
        clipProxy.sendNoteStateToObservers(n2, n4, n5);
    }

    static /* synthetic */ double access$400(ClipProxy clipProxy) {
        return clipProxy.getStepSize();
    }

    static /* synthetic */ void access$500(ClipProxy clipProxy, int n2) {
        clipProxy.setPlayingStep(n2);
    }

    static /* synthetic */ void access$600(ClipProxy clipProxy) {
        clipProxy.invalidateGrid();
    }
}

