/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.ramona.core.cKQ;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BankItemTargetUpdater
extends ControlSurfaceProxy
implements PEi {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private boolean mHasScheduledUpdate;
    private cKQ mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n2) {
        super(controlSurfaceObject);
        assert (cNz.DmN(controlSurfaceProxyArray != null));
        assert (cNz.DmN(n2 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n2;
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    public int getSizeOfBank() {
        return this.mItemProxies.length;
    }

    public ControlSurfaceProxy getItemAt(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n2);
    }

    public void scrollTo(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        this.postEvent(new BoI(this, Math.max(0, n2), true));
    }

    public void doScrollTo(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(n2 >= 0));
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n2);
        } else {
            this.doScrollToImpl(n2);
        }
    }

    protected int quantizePosition(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        int n4 = this.mItemProxies.length;
        int n5 = n4 < this.mScrollPositionThatPageShouldAlignTo ? this.mScrollPositionThatPageShouldAlignTo % n4 : 0;
        int n6 = (n2 - n5) / n4 * n4 + n5;
        int n7 = this.mListItemCount.getValue();
        if (n6 < this.mScrollPosition.getValue() - n4) {
            n6 += n4;
        }
        int n8 = (n7 - 1) / n4 * n4;
        return EvG.Gnn(n6, 0, n8);
    }

    private void doScrollToImpl(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        int n4 = EvG.Gnn(n2, 0, Math.max(0, this.mListItemCount.getValue() - this.mItemProxies.length));
        List list = this.getList();
        int n5 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n6 = n4 + i2;
            if (n6 < list.size()) {
                object = (cKQ)list.get(n6);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n5 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n6);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                super.doScrollToImpl(n4);
            }
        }
        this.mScrollPosition.setIntegerValue(n4);
        if (n5 >= 0) {
            this.mCursorIndex.setIntegerValue(n5);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n4 + this.mItemProxies.length < list.size());
        this.mCanScrollBackwards.setBoolValue(n4 > 0);
    }

    public void scrollBy(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.postEvent(new BoI(this, n2, false));
        }
    }

    public void doScrollBy(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n2));
    }

    public void scrollByPages(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.exec(() -> this.doScrollByPages(n2));
        }
    }

    private void doScrollByPages(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        this.doScrollBy(n2 * this.mItemProxies.length);
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public SettableIntegerValue getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (cNz.DmN(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public void listChanged() {
        assert (cNz.DmN(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::update);
        }
    }

    private void update() {
        assert (cNz.DmN(this.isDocumentThread()));
        List list = this.getList();
        this.update(list);
        this.mHasScheduledUpdate = false;
    }

    @Override
    protected void connectToTarget(Object object) {
        this.update();
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getList() {
        assert (cNz.DmN(this.isDocumentThread()));
        Object object = this.getTarget();
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        return this.calculateList(object);
    }

    protected abstract List calculateList(Object var1);

    protected void update(List list) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(list != null));
        int n2 = list.size() <= this.mItemProxies.length ? 0 : this.determineNewOffset(list);
        assert (cNz.DmN(n2 >= 0));
        assert (cNz.DmN(this.mItemProxies.length < list.size() ? n2 + this.mItemProxies.length <= list.size() : n2 == 0));
        int n4 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n5 = n2 + i2;
            if (n5 < list.size()) {
                object = (cKQ)list.get(n5);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && object == this.mCursor) {
                    n4 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n5);
        }
        Object object = this.getTarget();
        if (object != null) {
            this.mScrollPosition.setIntegerValue(n2);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n2 + this.mItemProxies.length < list.size());
            this.mCanScrollBackwards.setBoolValue(n2 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n4 >= 0) {
            this.mCursorIndex.setIntegerValue(n4);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (cNz.DmN(list.size() >= this.mItemProxies.length));
        assert (cNz.DmN(this.isDocumentThread()));
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            int n2;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            cKQ cKQ2 = (cKQ)controlSurfaceProxy.getTarget();
            if (cKQ2 == null || (n2 = list.indexOf(cKQ2)) < 0) continue;
            return EvG.Gnn(n2, 0, list.size() - this.mItemProxies.length);
        }
        return EvG.Gnn(this.mScrollPosition.getValue(), 0, list.size() - this.mItemProxies.length);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (cNz.DmN(bankItemTargetUpdater != null));
        assert (cNz.DmN(this.isControlSurfaceThread()));
        assert (cNz.DmN(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (cNz.DmN(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (cNz.DmN(bankItemTargetUpdater != null));
        assert (cNz.DmN(this.isControlSurfaceThread()));
        assert (cNz.DmN(this.isInitializingDriver()));
        assert (cNz.DmN(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (cNz.DmN(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (cNz.DmN(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public cKQ getFirstItem(cKQ cKQ2) {
        assert (cNz.DmN(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (cKQ)list.get(0);
        }
        return null;
    }

    @Override
    public cKQ getLastItem(cKQ cKQ2) {
        assert (cNz.DmN(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (cKQ)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public cKQ getPreviousItem(cKQ cKQ2) {
        assert (cNz.DmN(this.isDocumentThread()));
        List list = this.getList();
        if (cKQ2 == null) {
            if (!list.isEmpty()) {
                return (cKQ)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(cKQ2);
        if (n2 > 0) {
            return (cKQ)list.get(n2 - 1);
        }
        return null;
    }

    @Override
    public cKQ getNextItem(cKQ cKQ2) {
        assert (cNz.DmN(this.isDocumentThread()));
        List list = this.getList();
        if (cKQ2 == null) {
            if (!list.isEmpty()) {
                return (cKQ)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(cKQ2);
        if (n2 + 1 < list.size()) {
            return (cKQ)list.get(n2 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(cKQ cKQ2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(this.mCursorProxyToFollow != null));
        this.mCursor = cKQ2;
        if (cKQ2 != null) {
            this.doScrollToItem(cKQ2);
            int n2 = -1;
            for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
                ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
                cKQ cKQ3 = (cKQ)controlSurfaceProxy.getTarget();
                if (cKQ3 != cKQ2) continue;
                n2 = i2;
                break;
            }
            if (n2 >= 0) {
                this.mCursorIndex.setIntegerValue(n2);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(cKQ cKQ2) {
        int n2;
        assert (cNz.DmN(cKQ2 != null));
        assert (cNz.DmN(this.isDocumentThread()));
        List list = this.getList();
        int n4 = list.indexOf(cKQ2);
        if (n4 >= 0 && (n4 < (n2 = this.mScrollPosition.getValue()) || n4 >= n2 + this.mItemProxies.length)) {
            int n5 = this.quantizePosition(n4);
            assert (cNz.DmN(n4 >= n5 && n4 < n5 + this.mItemProxies.length));
            this.doScrollTo(n5);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new wJp("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (cNz.DmN(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        assert (cNz.DmN(n2 >= 0 && n2 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new wJp("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n2));
    }

    private void doMoveCursorToIndex(int n2) {
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(n2 >= 0 && n2 < this.getSizeOfBank()));
        assert (cNz.DmN(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n2];
        cKQ cKQ2 = (cKQ)controlSurfaceProxy.getTarget();
        if (cKQ2 != null) {
            this.mCursorProxyToFollow.doSelect(cKQ2);
        }
    }

    protected void moveCursorIndexBy(int n2) {
        assert (cNz.DmN(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new wJp("This bank is not following any cursor");
        }
        if (n2 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n2));
        }
    }

    private void doMoveCursorIndexBy(int n2) {
        int n4;
        assert (cNz.DmN(this.isDocumentThread()));
        assert (cNz.DmN(n2 != 0));
        assert (cNz.DmN(this.mCursorProxyToFollow != null));
        int n5 = this.mCursorIndex.getValue();
        assert (cNz.DmN(n5 >= 0 && n5 < this.getSizeOfBank() || n5 == -1));
        if (n5 >= 0 && n5 < this.getSizeOfBank() && (n4 = n5 + n2) >= 0 && n4 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n4);
        }
    }
}

