/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.platform;

import com.bitwig.base.io.J1C;
import com.bitwig.base.io.ProcessException;
import com.bitwig.base.io.njQ;
import com.bitwig.base.io.pMW;
import com.bitwig.base.platform.MacOsXIoKit;
import com.bitwig.base.platform.WindowsPlatform;
import com.bitwig.base.platform.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;

public final class Platform {
    private static String Gqs;
    private static UUID DmN;
    private static boolean qpf;
    private static File Wcd;
    private static File pQJ;

    public static void Gnn() {
        if (!qpf) {
            yLr.Gqs("base-platform");
            qpf = true;
        }
    }

    public static String Gqs() {
        if (Gqs == null) {
            Gqs = Platform.nfh();
        }
        assert (cMY.Gqs(Gqs != null));
        assert (cMY.Gqs(!Gqs.isEmpty()));
        return Gqs;
    }

    private static String nfh() {
        if (yLr.Gqs()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            String string2 = Platform.getNativeComputerName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                cMY.Gnn.qpf("Warning: determining macOS host name failed, using fallback instead.");
                string2 = InetAddress.getLocalHost().getHostName();
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                cMY.Gnn.qpf("Error: unable to determine macOS host name.");
            }
        } else if (yLr.Gnn()) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = System.getenv("COMPUTERNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
        } else if (yLr.qpf()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            try {
                String string3 = InetAddress.getLocalHost().getHostName();
                if (string3 != null && !string3.isEmpty()) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "localhost";
    }

    private static native String getNativeComputerName();

    public static UUID DmN() {
        if (DmN == null) {
            DmN = Platform.jtS();
        }
        assert (cMY.Gqs(DmN != null));
        return DmN;
    }

    private static UUID jtS() {
        if (yLr.Gnn()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483646, "SOFTWARE\\Microsoft\\Cryptography", "MachineGuid");
            return UUID.fromString(string);
        }
        if (yLr.Gqs()) {
            String string = MacOsXIoKit.readRegistryStringValue("IOPlatformUUID");
            return UUID.fromString(string);
        }
        if (yLr.qpf()) {
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[]{57, 22, 57, 79, 57, 88, 57, 75, 57, 22, 57, 85, 57, 80, 57, 91, 57, 22, 57, 93, 57, 91, 57, 76, 57, 74, 57, 22, 57, 84, 57, 88, 57, 90, 57, 81, 57, 80, 57, 87, 57, 92, 57, 20, 57, 80, 57, 93};
                String string = jCe.Gnn(byArray2);
                File file = null;
                File file2 = new File(string);
                if (file2.isFile()) {
                    file = file2;
                } else {
                    byArray = new byte[]{57, 22, 57, 92, 57, 77, 57, 90, 57, 22, 57, 84, 57, 88, 57, 90, 57, 81, 57, 80, 57, 87, 57, 92, 57, 20, 57, 80, 57, 93};
                    String string2 = jCe.Gnn(byArray);
                    file = new File(string2);
                }
                byArray = J1C.nfh(file);
                return UUID.nameUUIDFromBytes(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void qpf() {
        Thread.currentThread().setPriority(1);
        if (!yLr.Gnn()) {
            Platform.initThreadForBackgroundIONative();
        }
    }

    private static native void initThreadForBackgroundIONative();

    public static void Gnn(File file) {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (yLr.qpf()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file.getAbsolutePath());
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (yLr.Gqs()) {
            ProcessBuilder processBuilder = file.isDirectory() ? new ProcessBuilder("open", "-R", file.getAbsolutePath()) : new ProcessBuilder("open", file.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n4 = process.waitFor();
                if (n4 != 0) {
                    throw new IOException("open " + file.getAbsolutePath() + " returned error exit code " + n4);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (yLr.Gnn() && !WindowsPlatform.Gnn(file.getAbsolutePath())) {
            throw new IOException("Couldn't open file: " + file.getAbsolutePath());
        }
    }

    public static void Gnn(String string) {
        if (yLr.qpf()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", string);
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (yLr.Gqs()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", string);
            Process process = processBuilder.start();
            try {
                int n4 = process.waitFor();
                if (n4 != 0) {
                    throw new IOException("open " + string + " returned error exit code " + n4);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (yLr.Gnn() && !WindowsPlatform.Gnn(string)) {
            throw new IOException("Couldn't open URL: " + string);
        }
    }

    public static String Wcd() {
        try {
            if (yLr.qpf()) {
                return Platform.QOM();
            }
            if (yLr.Gnn()) {
                return Platform.kcS();
            }
            if (yLr.Gqs()) {
                return Platform.NKo();
            }
        }
        catch (Throwable throwable) {
            cMY.Gnn.Gqs(throwable);
        }
        return null;
    }

    private static String NKo() {
        try {
            pMW pMW2 = njQ.Gnn(new String[]{"sw_vers"}, null);
            if (pMW2.Gnn() == 0) {
                String string = pMW2.Gqs();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            return null;
        }
    }

    private static String kcS() {
        try {
            pMW pMW2 = njQ.Gnn(new String[]{"systeminfo"}, null);
            if (pMW2.Gnn() == 0) {
                String string = pMW2.Gqs();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            cMY.Gnn.Gqs(processException);
            return null;
        }
    }

    private static String QOM() {
        String string = Platform.qau();
        String string2 = Platform.p();
        return string + "\n" + string2;
    }

    private static String qau() {
        try {
            pMW pMW2 = njQ.Gnn(new String[]{"lsb_release", "-a"}, null);
            if (pMW2.Gnn() == 0) {
                String string = pMW2.Gqs();
                return string;
            }
            return "";
        }
        catch (ProcessException processException) {
            return "";
        }
    }

    private static String p() {
        try {
            return J1C.Gnn(new FileReader(new File("/proc/cpuinfo")));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static File pQJ() {
        return Wcd;
    }

    public static File dTJ() {
        return pQJ;
    }

    public static native void simulateCrashInNativeCode();

    public static File Gqs(String string) {
        if (yLr.Gnn()) {
            return Platform.pQJ(string);
        }
        if (yLr.Gqs()) {
            return Platform.Wcd(string);
        }
        if (yLr.qpf()) {
            return Platform.qpf(string);
        }
        assert (cMY.Gqs(false));
        return null;
    }

    private static File qpf(String string) {
        File file = new File("/media/" + string);
        if (!file.isDirectory()) {
            String string2 = System.getProperty("user.name");
            file = new File("/media/" + string2 + "/" + string);
            if (!(file.isDirectory() || (file = new File("/mnt/" + string)).isDirectory() || (file = new File("/mnt/" + string2 + "/" + string)).isDirectory())) {
                return null;
            }
        }
        return file;
    }

    private static File Wcd(String string) {
        File file = new File("/Volumes/" + string);
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File pQJ(String string) {
        File file;
        FileStore fileStore;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.type().equals("UDF") && !fileStore.type().equals("CDFS") || !fileStore.name().toLowerCase().startsWith(string.toLowerCase())) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.name().equalsIgnoreCase(string)) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static File DmN(String string) {
        if (yLr.Gnn()) {
            return Platform.nfh(string);
        }
        if (yLr.Gqs()) {
            return Platform.dTJ(string);
        }
        if (yLr.qpf()) {
            return Platform.jtS(string);
        }
        assert (cMY.Gqs(false));
        return null;
    }

    private static File dTJ(String string) {
        File file = new File("/Volumes");
        return Platform.Gnn(file, string);
    }

    private static File Gnn(File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File file3 = new File(file2, string);
                if (!file3.isDirectory()) continue;
                return file3;
            }
        }
        return null;
    }

    private static File nfh(String string) {
        File file;
        Object object;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                File file2;
                object = Files.getFileStore(path);
                file = path.toFile();
                if (!((FileStore)object).type().equals("UDF") && !((FileStore)object).type().equals("CDFS") || !(file2 = new File(file, string)).isDirectory()) continue;
                return file2;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            object = path.toFile();
            file = new File((File)object, string);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private static File jtS(String string) {
        String string2 = System.getProperty("user.name");
        File file = Platform.Gnn(new File("/media/" + string2), string);
        if (file == null && (file = Platform.Gnn(new File("/media"), string)) == null && (file = Platform.Gnn(new File("/mnt/" + string2), string)) == null) {
            file = Platform.Gnn(new File("/mnt"), string);
        }
        return file;
    }

    static {
        Platform.Gnn();
        if (yLr.Gnn()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "DESKTOP");
            Wcd = string != null && !string.isEmpty() ? new File(string) : new File(J1C.Gqs(), "Desktop");
            String string2 = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
            if (string2 != null && !string2.isEmpty()) {
                pQJ = new File(string2);
            } else {
                Wcd = new File(J1C.Gqs(), "Documents");
            }
        } else {
            Wcd = new File(J1C.Gqs(), "Desktop");
            pQJ = J1C.Gqs();
        }
    }
}

