/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.util.midi.ShortMidiMessage;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.ControllerExtensionDefinition;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Signal;
import com.bitwig.extension.controller.api.Transport;
import java.util.HashSet;
import java.util.function.Consumer;

public class FPQ
extends ControllerExtension {
    private Transport Gnn;
    private CursorTrack Gqs;
    private PinnableCursorDevice DmN;
    private CursorRemoteControlsPage qpf;
    private NoteInput Wcd;
    private sGL[] pQJ = new sGL[8];
    private sGL dTJ;
    private uTM nfh;
    private uTM jtS;
    private uTM NKo;
    private uTM kcS;
    private Signal QOM;
    private Signal qau;
    private Signal p;
    private TLQ xLh = null;
    private HashSet npQ = new HashSet();
    private int ryq = 0;

    protected FPQ(ControllerExtensionDefinition controllerExtensionDefinition, ControllerHost controllerHost) {
        super(controllerExtensionDefinition, controllerHost);
    }

    @Override
    public void init() {
        SettableRangedValue settableRangedValue;
        int n2;
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        Preferences preferences = controllerHost.getPreferences();
        controllerHost.getMidiInPort(0).setMidiCallback(shortMidiMessage -> this.Gnn(shortMidiMessage));
        controllerHost.getMidiInPort(0).setSysexCallback(string -> this.Gnn(string));
        this.Wcd = controllerHost.getMidiInPort(0).createNoteInput("", new String[0]);
        this.Gnn = controllerHost.createTransport();
        this.Gqs = controllerHost.createCursorTrack(0, 0);
        this.DmN = this.Gqs.createCursorDevice();
        this.qpf = this.DmN.createCursorRemoteControlsPage(8);
        for (n2 = 0; n2 < 8; ++n2) {
            settableRangedValue = this.qpf.getParameter(n2);
            settableRangedValue.setIndication(true);
            settableRangedValue.setLabel("Knob " + Integer.toString(n2 + 1));
        }
        this.QOM = preferences.getSignalSetting("Learn", "Remote Controls", "Learn");
        this.QOM.addSignalObserver(this::Gnn);
        for (n2 = 0; n2 < 8; ++n2) {
            settableRangedValue = preferences.getNumberSetting("CC " + Integer.toString(n2 + 1), "Remote Controls", -1.0, 119.0, 1.0, "", -1.0);
            this.pQJ[n2] = new sGL(this.qpf.getParameter(n2), settableRangedValue);
        }
        this.qau = preferences.getSignalSetting("Learn", "Cursor Track", "Learn");
        this.qau.addSignalObserver(this::Gqs);
        this.dTJ = new sGL(this.Gqs.getVolume(), preferences.getNumberSetting("Volume CC", "Cursor Track", -1.0, 119.0, 1.0, "", -1.0));
        this.p = preferences.getSignalSetting("Learn", "Transport", "Learn");
        this.p.addSignalObserver(this::DmN);
        this.nfh = new uTM(this.Gnn::play, preferences.getNumberSetting("Play CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
        this.NKo = new uTM(this.Gnn::stop, preferences.getNumberSetting("Stop CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
        this.jtS = new uTM(this.Gnn::record, preferences.getNumberSetting("Record CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
        this.kcS = new uTM(this.Gnn.isArrangerLoopEnabled()::toggle, preferences.getNumberSetting("Cycle CC", "Transport", -1.0, 119.0, 1.0, "", -1.0));
    }

    private void Gnn() {
        ((ControllerHost)this.getHost()).showPopupNotification("Move Remote 1");
        this.xLh = TLQ.Gnn;
        this.ryq = 0;
        this.npQ.clear();
    }

    private void Gqs() {
        ((ControllerHost)this.getHost()).showPopupNotification("Move control to use for volume");
        this.xLh = TLQ.Gqs;
        this.ryq = 0;
        this.npQ.clear();
    }

    private void DmN() {
        ((ControllerHost)this.getHost()).showPopupNotification("Push PLAY button");
        this.xLh = TLQ.DmN;
        this.ryq = 0;
        this.npQ.clear();
    }

    @Override
    public void exit() {
    }

    private void Gnn(ShortMidiMessage shortMidiMessage) {
        if (shortMidiMessage.isControlChange()) {
            int n2 = shortMidiMessage.getData1();
            if (this.xLh == TLQ.Gnn) {
                if (!this.npQ.contains(n2)) {
                    this.pQJ[this.ryq].Gqs(n2);
                    this.npQ.add(n2);
                    ++this.ryq;
                    if (this.ryq >= 8) {
                        ((ControllerHost)this.getHost()).showPopupNotification("Learning complete.");
                        this.xLh = null;
                        this.npQ.clear();
                    } else {
                        ((ControllerHost)this.getHost()).showPopupNotification("Move Remote " + Integer.toString(this.ryq + 1));
                    }
                }
            } else if (this.xLh == TLQ.Gqs) {
                if (!this.npQ.contains(n2)) {
                    this.dTJ.Gqs(n2);
                    ((ControllerHost)this.getHost()).showPopupNotification("Learning complete.");
                    this.xLh = null;
                }
            } else if (this.xLh == TLQ.DmN) {
                if (!this.npQ.contains(n2)) {
                    this.npQ.add(n2);
                    if (this.ryq == 0) {
                        this.nfh.Gqs(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Push STOP button.");
                        ++this.ryq;
                    } else if (this.ryq == 1) {
                        this.NKo.Gqs(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Push RECORD button.");
                        ++this.ryq;
                    } else if (this.ryq == 2) {
                        this.jtS.Gqs(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Push LOOP/CYCLE button.");
                        ++this.ryq;
                    } else {
                        this.kcS.Gqs(n2);
                        ((ControllerHost)this.getHost()).showPopupNotification("Learning complete.");
                        this.xLh = null;
                        this.ryq = 0;
                        this.npQ.clear();
                    }
                }
            } else {
                this.Gnn((T yUH2) -> {
                    if (yUH2.DmN(n2)) {
                        int n4 = shortMidiMessage.getData2();
                        yUH2.Gnn(n4);
                    }
                });
            }
        }
    }

    void Gnn(Consumer consumer) {
        consumer.accept(this.dTJ);
        for (sGL sGL2 : this.pQJ) {
            consumer.accept(sGL2);
        }
        consumer.accept(this.nfh);
        consumer.accept(this.NKo);
        consumer.accept(this.jtS);
        consumer.accept(this.kcS);
    }

    private void Gnn(String string) {
        if (string.equals("f07f7f0605f7")) {
            this.Gnn.rewind();
        } else if (string.equals("f07f7f0604f7")) {
            this.Gnn.fastForward();
        } else if (string.equals("f07f7f0601f7")) {
            this.Gnn.stop();
        } else if (string.equals("f07f7f0602f7")) {
            this.Gnn.play();
        } else if (string.equals("f07f7f0606f7")) {
            this.Gnn.record();
        }
    }

    @Override
    public void flush() {
    }
}

