/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.x11_windowing_system;

import com.bitwig.base.geom.tEf;
import com.bitwig.base.platform.NativeMemoryBlock;
import com.bitwig.graphics.CW1;
import com.bitwig.graphics.JgE;
import com.bitwig.graphics.KYu;
import com.bitwig.graphics.cairo.CairoBitmapSurface;
import com.bitwig.graphics.cairo.CairoGraphicsOutput;
import com.bitwig.x11_windowing_system.OB;
import com.bitwig.x11_windowing_system.X11Display;
import com.bitwig.x11_windowing_system.X11TopLevelWindowHandle;
import com.bitwig.x11_windowing_system.X11WindowingSystem;
import java.util.List;

class X11ImageDoubleBuffer
extends OB {
    private final int XWz;
    private final CairoBitmapSurface hOH;
    private NativeMemoryBlock ciw;
    private int LRY = -1;
    private long sY3 = -1L;
    private int pwJ;
    private boolean P3C;
    private final int zK;
    private final CW1 AH;

    X11ImageDoubleBuffer(X11TopLevelWindowHandle x11TopLevelWindowHandle, CW1 cW1) {
        super(x11TopLevelWindowHandle);
        this.AH = cW1;
        assert (cOw.aMA(this.aMA >= 0));
        assert (cOw.aMA(this.JbM >= 0));
        int n2 = CairoBitmapSurface.dOo(cW1, this.aMA);
        this.XWz = n2 * this.JbM;
        assert (cOw.aMA(this.XWz > 0));
        X11Display x11Display = this.dOo.kWi;
        if (x11TopLevelWindowHandle.kWi.P3C() && x11TopLevelWindowHandle.kWi.zK()) {
            this.LRY = X11ImageDoubleBuffer.getSharedMemory(this.XWz);
            if (this.LRY != -1) {
                this.sY3 = X11ImageDoubleBuffer.attachSharedMemory(this.LRY);
                if (this.sY3 != -1L) {
                    this.pwJ = X11ImageDoubleBuffer.attachSharedMemoryToDisplay(x11Display.dOo, this.LRY);
                    if (this.pwJ != 0) {
                        this.ciw = NativeMemoryBlock.dOo(this.sY3, this.XWz);
                        this.P3C = true;
                    } else {
                        X11WindowingSystem.aMA.kWi("Could not attach allocated shared memory double buffer to the display with size " + this.aMA + ", " + this.JbM);
                        X11ImageDoubleBuffer.detachSharedMemory(this.sY3);
                        this.sY3 = -1L;
                        X11ImageDoubleBuffer.removeSharedMemory(this.LRY);
                        this.LRY = -1;
                    }
                } else {
                    X11ImageDoubleBuffer.removeSharedMemory(this.LRY);
                    this.LRY = -1;
                    X11WindowingSystem.aMA.kWi("Could not attach shared memory for double buffer with size " + this.aMA + ", " + this.JbM);
                }
            } else {
                X11WindowingSystem.aMA.kWi("Could not get shared memory for double buffer with size " + this.aMA + ", " + this.JbM);
            }
        }
        if (!this.P3C) {
            X11WindowingSystem.aMA.kWi("Could not initialize shared memory double buffer");
            this.ciw = NativeMemoryBlock.dOo(this.XWz);
        }
        assert (cOw.aMA(this.ciw != null));
        this.hOH = new CairoBitmapSurface(this.ciw.dOo(), this.aMA, this.JbM, CW1.aMA);
        this.zK = x11Display.aMA(this.dOo.mWindowId);
    }

    @Override
    public void dOo() {
        this.dOo.kWi.JbM(this.zK);
        this.hOH.gj_();
        if (this.ciw != null) {
            this.ciw.kWi();
            this.ciw = null;
        }
        if (this.pwJ != 0) {
            X11ImageDoubleBuffer.detachSharedMemoryFromDisplay(this.dOo.hOH, this.pwJ);
            this.pwJ = 0;
        }
        if (this.sY3 != -1L) {
            X11ImageDoubleBuffer.detachSharedMemory(this.sY3);
            this.sY3 = -1L;
        }
        if (this.LRY != -1) {
            X11ImageDoubleBuffer.removeSharedMemory(this.LRY);
            this.LRY = -1;
        }
    }

    @Override
    public JgE c1E() {
        return new CairoGraphicsOutput(this.hOH, false);
    }

    @Override
    public void dOo(List list, boolean bl2) {
        int n2 = list.size() - 1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            tEf tEf2 = (tEf)list.get(i2);
            int n4 = tEf2.Den();
            int n5 = tEf2.brF();
            int n6 = tEf2.SoZ();
            int n7 = tEf2.niV();
            assert (cOw.aMA(n4 >= 0));
            assert (cOw.aMA(n5 >= 0));
            assert (cOw.aMA(n4 + n6 <= this.kWi));
            assert (cOw.aMA(n5 + n7 <= this.Iqr));
            if (n4 + n6 > this.kWi || n5 + n7 > this.Iqr) continue;
            this.dOo(n4, n5, n6, n7, i2 == n2);
        }
    }

    @Override
    public void dOo(int n2, int n4, int n5, int n6) {
        this.dOo(n2, n4, n5, n6, true);
    }

    private void dOo(int n2, int n4, int n5, int n6, boolean bl2) {
        assert (cOw.aMA(n2 >= 0));
        assert (cOw.aMA(n4 >= 0));
        assert (cOw.dOo(n2 + n5 <= this.kWi));
        assert (cOw.dOo(n4 + n6 <= this.Iqr));
        assert (cOw.dOo(n5 >= 0));
        assert (cOw.aMA(n6 >= 0));
        assert (cOw.aMA(this.dOo.hOH != 0L));
        if (this.P3C) {
            X11ImageDoubleBuffer.putSharedMemoryImage(this.dOo.hOH, this.dOo.mWindowId, this.zK, this.aMA, this.JbM, n2, n4, n5, n6, n2, n4, this.pwJ, bl2);
        } else if (n2 == 0 && n4 == 0 && n5 == this.aMA && n6 == this.JbM) {
            X11ImageDoubleBuffer.putImage(this.dOo.hOH, this.dOo.mWindowId, this.zK, n2, n4, n5, n6, this.XWz, this.ciw.c1E(), bl2);
        } else {
            int n7 = CairoBitmapSurface.dOo(this.AH, n5) * n6;
            long l2 = X11ImageDoubleBuffer.allocate(n7);
            CairoBitmapSurface cairoBitmapSurface = new CairoBitmapSurface(l2, n5, n6, this.AH);
            CairoGraphicsOutput cairoGraphicsOutput = new CairoGraphicsOutput(cairoBitmapSurface, true);
            ((JgE)cairoGraphicsOutput).dOo(KYu.aMA);
            ((JgE)cairoGraphicsOutput).dOo(this.hOH, (double)(-n2), (double)(-n4));
            cairoGraphicsOutput.aMA(0L, 0L, n5, n6);
            ((JgE)cairoGraphicsOutput).c1E();
            X11ImageDoubleBuffer.putImage(this.dOo.hOH, this.dOo.mWindowId, this.zK, n2, n4, n5, n6, n7, l2, bl2);
            ((JgE)cairoGraphicsOutput).Iqr();
            X11ImageDoubleBuffer.free(l2);
        }
        this.dOo.kWi.RU();
    }

    private static native long allocate(int var0);

    private static native void free(long var0);

    private static native int getSharedMemory(int var0);

    private static native void removeSharedMemory(int var0);

    private static native long attachSharedMemory(int var0);

    private static native void detachSharedMemory(long var0);

    private static native int attachSharedMemoryToDisplay(long var0, int var2);

    private static native void detachSharedMemoryFromDisplay(long var0, int var2);

    private static native void putSharedMemoryImage(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, boolean var13);

    private static native void putImage(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, boolean var11);
}

