/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.graphics.cairo;

import com.bitwig.graphics.Bitmap;
import com.bitwig.graphics.CW1;
import com.bitwig.graphics.cairo.CairoGraphicsOutput;
import com.bitwig.graphics.cairo.CairoSurface;
import java.nio.ByteBuffer;

public class CairoBitmapSurface
extends CairoSurface {
    private final ByteBuffer JbM;
    private final int kWi;
    private final int Iqr;
    private final int c1E;
    private final CW1 L1X;

    public CairoBitmapSurface(ByteBuffer byteBuffer, int n2, int n4, CW1 cW1) {
        super(CairoBitmapSurface.create(byteBuffer, n2, n4, CairoBitmapSurface.dOo(cW1, n2), cW1.ordinal()));
        this.JbM = byteBuffer;
        this.kWi = CairoBitmapSurface.dOo(cW1, n2);
        this.L1X = cW1;
        this.Iqr = n2;
        this.c1E = n4;
    }

    public CairoBitmapSurface(Bitmap bitmap) {
        this(bitmap.Iqr(), bitmap.c1E(), bitmap.L1X(), bitmap.ciw());
    }

    public CairoBitmapSurface(long l2, int n2, int n4, CW1 cW1) {
        super(CairoBitmapSurface.createForAddress(l2, n2, n4, CairoBitmapSurface.dOo(cW1, n2), cW1.ordinal()));
        this.JbM = null;
        this.kWi = CairoBitmapSurface.dOo(cW1, n2);
        this.L1X = cW1;
        this.Iqr = n2;
        this.c1E = n4;
        assert (cNV.JbM(l2 != 0L));
        assert (cNV.JbM(n2 > 0));
        assert (cNV.JbM(n4 > 0));
    }

    public static int dOo(CW1 cW1, int n2) {
        assert (cNV.JbM(cW1 != null));
        int n4 = CairoBitmapSurface.strideForWidthNative(cW1.ordinal(), n2);
        assert (cNV.JbM(n4 >= 0));
        return n4;
    }

    private static native int strideForWidthNative(int var0, int var1);

    private static native long create(ByteBuffer var0, int var1, int var2, int var3, int var4);

    private static native long createForAddress(long var0, int var2, int var3, int var4, int var5);

    public ByteBuffer aMA() {
        return this.JbM;
    }

    public int kWi() {
        return this.kWi;
    }

    public CW1 Iqr() {
        return this.L1X;
    }

    public int c1E() {
        return this.Iqr;
    }

    public int L1X() {
        return this.c1E;
    }

    static {
        CairoGraphicsOutput.wWc();
    }
}

