/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceString;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.IntelligentControlSurfaceString;
import com.bitwig.flt.control_surface.values.StringValueProxy$1;
import com.bitwig.flt.control_surface.values.StringValueProxy$2;
import com.bitwig.flt.control_surface.values.ValueProxy;

public class StringValueProxy
extends ValueProxy
implements StringValue,
ptT {
    private ControlSurfaceString mValue;
    private final ControlSurfaceString mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createControlSurfaceStringValue(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return SkR.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (cOb.JbM(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new StringValueProxy$1(this, stringValueChangedCallback));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new StringValueProxy$2(this, stringValueChangedCallback, string, n2));
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(SkR skR) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(skR != null));
        skR.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(SkR skR) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(skR != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(this.isActiveOnDocumentThread()));
        skR.addListener(this);
        this.updateValue();
    }

    public ControlSurfaceString getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(RUI rUI2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(VQJ.dOo(rUI2.dOo(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (cOb.JbM(this.isDocumentThread()));
        String string = (String)((SkR)this.getTarget()).getValue();
        assert (cOb.JbM(string != null));
        ControlSurfaceString controlSurfaceString = this.createControlSurfaceStringValue(string);
        assert (cOb.JbM(controlSurfaceString != null));
        this.queueNotifyObservers(controlSurfaceString);
    }

    private void queueNotifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(controlSurfaceString));
    }

    protected ControlSurfaceString createControlSurfaceStringValue(String string) {
        assert (cOb.JbM(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return ControlSurfaceString.EMPTY;
        }
        return new IntelligentControlSurfaceString(string);
    }

    private void notifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        if (!controlSurfaceString.equals(this.mValue)) {
            this.mValue = controlSurfaceString;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(controlSurfaceString);
                }
            }
        }
    }

    static /* synthetic */ ControlSurfaceString access$000(StringValueProxy stringValueProxy) {
        return stringValueProxy.mDefaultValue;
    }
}

