/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.ObjectValueChangedCallback;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.Arrays;

public class StringArrayValueProxy
extends ValueProxy
implements StringArrayValue,
ptT {
    private final String[] mDefaultValue;
    private String[] mValue;

    public StringArrayValueProxy(ControlSurfaceObject controlSurfaceObject, String[] stringArray) {
        super(controlSurfaceObject);
        this.mDefaultValue = stringArray;
        this.mValue = stringArray;
    }

    @Override
    public Class getTargetType() {
        return N2l.class;
    }

    @Override
    public String[] get() {
        this.checkCanGet();
        return this.mValue;
    }

    public void addValueObserver(ObjectValueChangedCallback objectValueChangedCallback) {
        this.doAddValueObserver(objectValueChangedCallback);
    }

    protected void sendDefaultValue(ObjectValueChangedCallback objectValueChangedCallback) {
        objectValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void connectToTarget(N2l n2l) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(n2l != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(this.isActiveOnDocumentThread()));
        n2l.addListener(this);
        this.queueNotifyObservers((String[])n2l.getValue());
    }

    protected void disconnectFromTarget(N2l n2l) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(n2l != null));
        n2l.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    public void eventOccurred(RUI rUI2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.mObservers != null));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(VQJ.dOo(rUI2.dOo(), this.getTarget())));
        String[] stringArray = (String[])((N2l)this.getTarget()).getValue();
        this.queueNotifyObservers(stringArray);
    }

    private void queueNotifyObservers(String[] stringArray) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(stringArray));
    }

    private void notifyObservers(String[] stringArray) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        if (!Arrays.equals(stringArray, this.mValue)) {
            this.mValue = stringArray;
            if (this.mObservers != null) {
                for (ObjectValueChangedCallback objectValueChangedCallback : this.mObservers) {
                    objectValueChangedCallback.valueChanged(stringArray);
                }
            }
        }
    }
}

