/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.SignalProxy;
import com.bitwig.ramona.core.VSu;

public class SignalSetting
extends SignalProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final String mAction;
    private QsG mIsEnabled;
    private QsG mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private VSu mSetting;

    public SignalSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, String string3) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new XuJ("Error: label for setting can't be empty.");
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mAction = string3;
    }

    public void connectToSetting(Qg qg2) {
        assert (cOb.kWi(this.mSetting == null));
        this.mSetting = qg2;
        this.setTarget(qg2.hOH());
        this.connectEnableAndVisibleValues(qg2.Mpc(), qg2.bSR());
    }

    public void disconnectFromSetting(Qg qg2) {
        assert (cOb.kWi(this.mSetting == qg2));
        this.disconnectEnableAndVisibleValues(qg2.Mpc(), qg2.bSR());
        this.setTarget(null);
        this.mSetting = null;
    }

    public void connectToSetting(OHC oHC) {
        assert (cOb.kWi(this.mSetting == null));
        this.mSetting = oHC;
        this.setTarget(oHC.aMA());
        this.connectEnableAndVisibleValues(oHC.L1X(), oHC.XWz());
    }

    public void disconnectFromSetting(OHC oHC) {
        assert (cOb.kWi(this.mSetting == oHC));
        this.disconnectEnableAndVisibleValues(oHC.L1X(), oHC.XWz());
        this.setTarget(null);
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(QsG qsG, QsG qsG2) {
        this.mIsEnabled = qsG;
        this.mIsVisible = qsG2;
    }

    private void disconnectEnableAndVisibleValues(QsG qsG, QsG qsG2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public String getAction() {
        return this.mAction;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        if (this.mIsVisible != null) {
            this.mIsVisible.setValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public VSu getSetting() {
        return this.mSetting;
    }
}

