/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.NoArgsCallback;
import com.bitwig.extension.controller.api.Signal;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.ramona.core.SIB;
import java.util.ArrayList;
import java.util.List;

public class SignalProxy
extends ControlSurfaceProxy
implements HUt,
Signal {
    private List mObservers;

    public SignalProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public Class getTargetType() {
        return SIB.class;
    }

    @Override
    public void addSignalObserver(NoArgsCallback noArgsCallback) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (noArgsCallback == null) {
            throw new XuJ("observer cannot be null");
        }
        if (this.mObservers == null) {
            this.mObservers = new ArrayList(2);
        }
        this.mObservers.add(noArgsCallback);
    }

    @Override
    public void fire() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(this::doFire);
    }

    private void doFire() {
        assert (cOb.JbM(this.isDocumentThread()));
        SIB sIB = (SIB)this.getTarget();
        if (sIB != null) {
            sIB.run();
        }
    }

    protected void disconnectFromTarget(SIB sIB) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(sIB != null));
        if (this.mObservers != null) {
            sIB.removeListener(this);
        }
    }

    public void connectToTarget(SIB sIB) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(sIB != null));
        if (this.mObservers != null) {
            sIB.addListener(this);
        }
    }

    @Override
    public void eventOccurred(Object object) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.queueNotifyObservers();
    }

    private void queueNotifyObservers() {
        assert (cOb.JbM(this.isDocumentThread()));
        if (this.mObservers != null) {
            this.queueCallback(this, () -> this.notifyObservers());
        }
    }

    private void notifyObservers() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.mObservers != null));
        assert (cOb.JbM(!this.mObservers.isEmpty()));
        for (NoArgsCallback noArgsCallback : this.mObservers) {
            noArgsCallback.call();
        }
    }
}

