/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy;
import com.bitwig.flt.control_surface.values.DocumentNumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.NumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.PreferencesNumberSettingRangedValueTarget;
import com.bitwig.ramona.core.VSu;

public class NumberSetting
extends AbstractRangedValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final double mMinValue;
    private final double mMaxValue;
    private final double mStepResolution;
    private final String mUnit;
    private final double mDefaultValue;
    private QsG mIsEnabled;
    private QsG mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private VSu mSetting;

    public NumberSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, double d2, double d3, double d4, String string3, double d5) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new XuJ("Error: label for setting can't be empty.");
        }
        if (string3 == null) {
            string3 = "";
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mMinValue = d2;
        this.mMaxValue = d3;
        this.mStepResolution = d4;
        this.mUnit = string3;
        this.mDefaultValue = d5;
        this.setKey("Setting/" + string2 + "/" + string);
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    @Override
    public Class getTargetType() {
        return NumberSettingRangedValueTarget.class;
    }

    public void connectToSetting(PY pY2) {
        assert (cOb.kWi(this.mSetting == null));
        this.mSetting = pY2;
        this.setTarget(new PreferencesNumberSettingRangedValueTarget(pY2));
        this.connectEnableAndVisibleValues(pY2.Mpc(), pY2.bSR());
    }

    public void disconnectFromSetting(PY pY2) {
        assert (cOb.kWi(this.mSetting == pY2));
        this.disconnectEnableAndVisibleValues(pY2.Mpc(), pY2.bSR());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(vPE vPE2) {
        assert (cOb.kWi(this.mSetting == null));
        this.mSetting = vPE2;
        this.setTarget(new DocumentNumberSettingRangedValueTarget(vPE2));
        this.connectEnableAndVisibleValues(vPE2.L1X(), vPE2.XWz());
    }

    public void disconnectFromSetting(vPE vPE2) {
        assert (cOb.kWi(this.mSetting == vPE2));
        this.disconnectEnableAndVisibleValues(vPE2.L1X(), vPE2.XWz());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(QsG qsG, QsG qsG2) {
        this.mIsEnabled = qsG;
        this.mIsVisible = qsG2;
    }

    private void disconnectEnableAndVisibleValues(QsG qsG, QsG qsG2) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    protected double getCurrentValue() {
        double d2 = super.getCurrentValue();
        int n2 = (int)Math.round(d2 / this.mStepResolution);
        return this.mStepResolution * (double)n2;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public double getStepResolution() {
        return this.mStepResolution;
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        if (this.mIsVisible != null) {
            this.mIsVisible.setValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public VSu getSetting() {
        return this.mSetting;
    }
}

