/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;

public class IntegerValueProxy
extends ValueProxy
implements IntegerValue,
ptT {
    private int mValue;
    private final int mDefaultValue;
    private List mUnassignedObservers;

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.mValue = n2;
        this.mDefaultValue = n2;
    }

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0);
    }

    @Override
    public Class getTargetType() {
        return nZX.class;
    }

    @Override
    public int get() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public int getControlSurfaceValue() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        if (n2 == this.mDefaultValue) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n2));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(nZX nZX2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(nZX2 != null));
        nZX2.removeListener(this);
        this.queueNotifyObserversUnassigned();
    }

    protected void connectToTarget(nZX nZX2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(nZX2 != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(this.isActiveOnDocumentThread()));
        nZX2.addListener(this);
        this.queueNotifyObservers(nZX2.getIntegerValue());
    }

    public int getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(RUI rUI2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(VQJ.dOo(rUI2.dOo(), this.getTarget())));
        int n2 = ((nZX)this.getTarget()).getIntegerValue();
        this.queueNotifyObservers(n2);
    }

    private void queueNotifyObserversUnassigned() {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(this.mDefaultValue, false));
    }

    private void queueNotifyObservers(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(n2, true));
    }

    private void notifyObservers(int n2, boolean bl2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(!bl2 ? n2 == this.mDefaultValue : true));
        if (n2 != this.mValue) {
            this.mValue = n2;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n2);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n2);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

