/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;

public class DoubleValueProxy
extends ValueProxy
implements DoubleValue,
ptT {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d2) {
        super(controlSurfaceObject);
        this.mValue = d2;
        this.mDefaultValue = d2;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return XYN.class;
    }

    @Override
    public double get() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(XYN xYN) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(xYN != null));
        xYN.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(XYN xYN) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(xYN != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(this.isActiveOnDocumentThread()));
        xYN.addListener(this);
        this.queueNotifyObservers(xYN.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(RUI rUI2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(VQJ.dOo(rUI2.dOo(), this.getTarget())));
        double d2 = ((XYN)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d2);
    }

    private void queueNotifyObservers(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d2));
    }

    private void notifyObservers(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        if (d2 != this.mValue) {
            this.mValue = d2;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d2);
                }
            }
        }
    }
}

