/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedValue;

public class ComputedBooleanValue
extends ComputedValue
implements BooleanValue {
    private final boolean mDefaultValue;
    private boolean mValue;
    private boolean mDocumentValue;

    public ComputedBooleanValue(ControlSurfaceObject controlSurfaceObject, boolean bl2) {
        super(controlSurfaceObject);
        this.mDefaultValue = bl2;
        this.mValue = bl2;
        this.mDocumentValue = bl2;
    }

    public ComputedBooleanValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, false);
    }

    @Override
    public boolean get() {
        this.checkCanGet();
        return this.mValue;
    }

    public boolean getBoolValue() {
        assert (cOb.JbM(this.isDocumentThread()));
        return this.mDocumentValue;
    }

    public void setBoolValue(boolean bl2) {
        assert (cOb.JbM(this.isDocumentThread()));
        if (bl2 != this.mDocumentValue) {
            this.mDocumentValue = bl2;
            if (this.isInterested()) {
                this.queueNotifyObservers(bl2);
            }
        }
    }

    public void unassigned() {
        assert (cOb.JbM(this.isDocumentThread()));
        this.setBoolValue(this.mDefaultValue);
    }

    public void addValueObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.doAddValueObserver(booleanValueChangedCallback);
    }

    protected void sendInitialValue(BooleanValueChangedCallback booleanValueChangedCallback) {
        booleanValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(boolean bl2) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(bl2));
    }

    private void notifyObservers(boolean bl2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        if (bl2 != this.mValue) {
            this.mValue = bl2;
            if (this.mObservers != null) {
                for (BooleanValueChangedCallback booleanValueChangedCallback : this.mObservers) {
                    booleanValueChangedCallback.valueChanged(bl2);
                }
            }
        }
    }
}

