/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy$IntegerScaledValueObserver;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceString;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.flt.control_surface.values.ValueProxy;
import com.bitwig.flt.prefs.Ts;
import com.bitwig.ramona.core.Dr2;
import gnu.trove.list.TDoubleList;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRangedValueProxy
extends ValueProxy
implements SettableRangedValue,
ptT {
    private double mRawValue;
    private double mNormalizedValue;
    private List mRawValueCallbacks;
    private List mIntegerScaledValueObservers;
    protected final ComputedStringValue mDisplayedValue = this.createDisplayedValue();
    private boolean mHasBeenCaught;
    private boolean mIsSettingValue;
    private double mLastSetNormalizedValue = -1.0;

    protected AbstractRangedValueProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public double getRaw() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRawValue;
    }

    @Override
    public double get() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mNormalizedValue;
    }

    @Override
    public StringValue displayedValue() {
        this.newSince(2);
        return this.mDisplayedValue;
    }

    public ComputedStringValue getDisplayedValue() {
        return this.mDisplayedValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (cOb.JbM(false));
        assert (cOb.JbM(this.isControlSurfaceThread()));
    }

    @Override
    public void addValueObserver(int n2, IntegerValueChangedCallback integerValueChangedCallback) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (n2 <= 1) {
            throw new XuJ("Range must be > 1");
        }
        this.doMarkInterested();
        if (this.mIntegerScaledValueObservers == null) {
            this.mIntegerScaledValueObservers = new ArrayList(2);
        }
        this.mIntegerScaledValueObservers.add(new AbstractRangedValueProxy$IntegerScaledValueObserver(n2, integerValueChangedCallback));
    }

    @Override
    public final void set(Number number, Number number2) {
        double d2;
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (number == null || number2 == null) {
            throw new XuJ("Cannot provide null for value or resolution");
        }
        double d3 = number.doubleValue();
        if (d3 > (d2 = number2.doubleValue()) - 1.0) {
            this.getControlSurface().aMA("Value must be <= range - 1. Setting value to range - 1");
        }
        if (d3 < 0.0) {
            this.getControlSurface().aMA("Value must be >= 0. Setting value to 0");
        }
        d3 = VCg.aMA(d3, 0.0, d2 - 1.0);
        assert (cOb.JbM(number != null));
        assert (cOb.JbM(number2 != null));
        double d4 = d2 >= 2.0 ? 1.0 / (d2 - 1.0) : 1.0;
        double d5 = d3 * d4;
        assert (cOb.JbM(d5 >= 0.0 && d5 <= 1.0));
        this.setNormalizedValue(d5, this.shouldSetImmediately());
    }

    @Override
    public final void set(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, this.shouldSetImmediately());
    }

    void markAsNotCaught() {
        assert (cOb.JbM(this.isDocumentThread()));
        this.mHasBeenCaught = false;
    }

    private boolean shouldSetImmediately() {
        Ljv ljv2 = this.getControlSurface();
        if (ljv2.Den().Den()) {
            return !ljv2.brF().Den();
        }
        return false;
    }

    @Override
    public void setImmediately(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.newSince(4);
        this.inRange(d2, 0.0, 1.0, "value");
        this.setNormalizedValue(d2, true);
    }

    private void setNormalizedValue(double d2, boolean bl2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(d2 >= 0.0 && d2 <= 1.0));
        this.postEvent(new CZN(this, d2, bl2, this.getTouchId()));
    }

    protected int getTouchId() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        return 0;
    }

    public void doSetNormalizedValueWithTakeOver(double d2, Ts ts2, TDoubleList tDoubleList) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(d2 >= 0.0 && d2 <= 1.0));
        assert (cOb.JbM(ts2 != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            if (this.mHasBeenCaught || ts2 == Ts.dOo) {
                this.doSetNormalizedValueImmediately(d2);
            } else {
                assert (cOb.JbM(!this.mHasBeenCaught));
                assert (cOb.JbM(ts2 != Ts.dOo));
                double d3 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                boolean bl2 = false;
                if (this.mLastSetNormalizedValue != -1.0) {
                    double d4 = tDoubleList != null ? tDoubleList.get(0) : d2;
                    bl2 = AbstractRangedValueProxy.shouldBeCaughtByMovement(this.mLastSetNormalizedValue, d4, d3, ts2);
                }
                if (!bl2 && tDoubleList != null) {
                    for (int i2 = 0; !bl2 && i2 < tDoubleList.size() - 1; ++i2) {
                        double d5 = tDoubleList.get(i2);
                        double d6 = tDoubleList.get(i2 + 1);
                        bl2 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d5, d6, d3, ts2);
                    }
                    if (!bl2) {
                        double d7 = tDoubleList.get(tDoubleList.size() - 1);
                        bl2 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d7, d2, d3, ts2);
                    }
                }
                if (bl2) {
                    this.doSetNormalizedValueImmediately(d2);
                }
            }
        }
    }

    private static boolean shouldBeCaughtByMovement(double d2, double d3, double d4, Ts ts2) {
        assert (cOb.JbM(d2 >= 0.0 && d2 <= 1.0));
        assert (cOb.JbM(d3 >= 0.0 && d3 <= 1.0));
        assert (cOb.JbM(d4 >= 0.0 && d4 <= 1.0));
        assert (cOb.JbM(ts2 != null));
        double d5 = Math.min(d2, d3);
        double d6 = Math.max(d2, d3);
        if (d4 >= d5 && d4 <= d6) {
            return true;
        }
        return ts2 == Ts.JbM ? Math.signum(d3 - d2) != Math.signum(d4 - d2) : AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d2, d4) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d4);
    }

    private static boolean isValueCloseEnoughForTakeOver(double d2, double d3) {
        return Math.abs(d2 - d3) <= 0.05;
    }

    public void doSetNormalizedValueImmediately(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(d2 >= 0.0 && d2 <= 1.0));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            double d3 = this.normalizedValueToValue(d2);
            this.setCurrentValue(d3);
            this.mLastSetNormalizedValue = d2;
            this.mHasBeenCaught = true;
        }
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.markAsNotCaught();
    }

    @Override
    public final void inc(Number number, Number number2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (number == null) {
            throw new XuJ("increment cannot be null");
        }
        if (number2 == null) {
            throw new XuJ("range cannot be null");
        }
        if (number2.doubleValue() <= 1.0) {
            throw new XuJ("range must be > 1");
        }
        double d2 = number.doubleValue() / (number2.doubleValue() - 1.0);
        this.incNormalized(d2);
    }

    @Override
    public void inc(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.inRange(d2, -1.0, 1.0, "increment");
        this.newSince(2);
        this.incNormalized(d2);
    }

    public void incNormalized(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(d2 >= -1.0 && d2 <= 1.0));
        this.postEvent(new CZN(this, d2, this.getTouchId()));
    }

    public boolean isMappable() {
        return false;
    }

    public boolean addMapping(nAM nAM2, boolean bl2, Dr2 dr2, psj psj2) {
        assert (cOb.JbM(this.isMappable()));
        return false;
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.notNull(doubleValueChangedCallback, "callback");
        this.checkIsInitializingDriver();
        this.doMarkInterested();
        if (this.mRawValueCallbacks == null) {
            this.mRawValueCallbacks = new ArrayList(2);
        }
        this.mRawValueCallbacks.add(doubleValueChangedCallback);
    }

    @Override
    public void setRaw(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetRaw(d2));
    }

    private void doSetRaw(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(d2));
        }
    }

    @Override
    public void incRaw(double d2) {
        this.exec(() -> this.doIncRaw(d2));
    }

    private void doIncRaw(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(this.getCurrentValue() + d2));
        }
    }

    protected double validateRawValue(double d2) {
        return d2;
    }

    public void connectToTarget(RangedValueTarget rangedValueTarget) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(rangedValueTarget != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(this.isActiveOnDocumentThread()));
        N2l n2l = this.getTargetValue(rangedValueTarget);
        n2l.addListener(this);
        this.updateValueFromTarget();
        this.markAsNotCaught();
    }

    public void disconnectFromTarget(RangedValueTarget rangedValueTarget) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(rangedValueTarget != null));
        N2l n2l = this.getTargetValue(rangedValueTarget);
        n2l.removeListener(this);
        this.queueNotifyObservers(0.0, 0.0);
        if (this.mDisplayedValue.isInterested()) {
            this.mDisplayedValue.unassign();
        }
        this.markAsNotCaught();
    }

    protected N2l getTargetValue(RangedValueTarget rangedValueTarget) {
        assert (cOb.JbM(this.isDocumentThread()));
        return rangedValueTarget.getValue();
    }

    public void eventOccurred(RUI rUI2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(VQJ.dOo(rUI2.dOo(), this.getTargetValue((RangedValueTarget)this.getTarget()))));
        this.updateValueFromTarget();
        if (!this.mIsSettingValue) {
            this.markAsNotCaught();
        }
    }

    private void updateValueFromTarget() {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        double d2 = this.getCurrentValue();
        this.queueNotifyObserversRaw(d2);
        if (this.mDisplayedValue.isInterested()) {
            ControlSurfaceString controlSurfaceString = this.createControlSurfaceString(d2);
            assert (cOb.JbM(controlSurfaceString != null));
            this.mDisplayedValue.setValue(controlSurfaceString);
        }
    }

    protected ComputedStringValue createDisplayedValue() {
        return new ComputedStringValue(this);
    }

    protected ControlSurfaceString createControlSurfaceString(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).createControlSurfaceStringForValue(d2);
    }

    protected double getCurrentValue() {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).getCurrentValue();
    }

    protected void setCurrentValue(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(((RangedValueTarget)this.getTarget()).isSettable()));
        assert (cOb.JbM(!this.mIsSettingValue));
        this.beginSettingValue();
        ((RangedValueTarget)this.getTarget()).setCurrentValue(d2);
        this.endSettingValue();
    }

    protected double valueToNormalizedValue(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).valueToNormalizedValue(d2);
    }

    protected double normalizedValueToValue(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).normalizedValueToValue(d2);
    }

    public void doIncNormalized(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(!this.mIsSettingValue));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.beginSettingValue();
            rangedValueTarget.incrementNormalized(d2);
            this.endSettingValue();
        }
    }

    private void beginSettingValue() {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(!this.mIsSettingValue));
        this.mIsSettingValue = true;
    }

    private void endSettingValue() {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.mIsSettingValue));
        assert (cOb.JbM(this.getTarget() != null));
        assert (cOb.JbM(((RangedValueTarget)this.getTarget()).isSettable()));
        this.mIsSettingValue = false;
        if (((RangedValueTarget)this.getTarget()).shouldShowPopupNotifications()) {
            this.doShowPopupNotification();
        }
    }

    public void showPopupNotification() {
        assert (cOb.JbM(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable() && rangedValueTarget.shouldShowPopupNotifications()) {
            this.doShowPopupNotification();
        }
    }

    private void doShowPopupNotification() {
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(rangedValueTarget != null));
        assert (cOb.JbM(rangedValueTarget.isSettable()));
        assert (cOb.JbM(rangedValueTarget.shouldShowPopupNotifications()));
        String string = rangedValueTarget.getPopupNotificationName();
        String string2 = rangedValueTarget.getPopupNotificationValueText();
        this.getControlSurface().dOo(string2, string);
    }

    private final void queueNotifyObserversRaw(double d2) {
        double d3 = this.valueToNormalizedValue(d2);
        this.queueNotifyObservers(d2, d3);
    }

    private void queueNotifyObservers(double d2, double d3) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(d3 >= 0.0 && d3 <= 1.0));
        this.queueCallback(this, () -> this.notifyObservers(d2, d3));
    }

    private void notifyObservers(double d2, double d3) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInterested()));
        assert (cOb.JbM(d3 >= 0.0 && d3 <= 1.0));
        double d4 = this.mRawValue;
        double d5 = this.mNormalizedValue;
        this.mRawValue = d2;
        this.mNormalizedValue = d3;
        if (d3 != d5) {
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(d3);
                }
            }
            if (this.mIntegerScaledValueObservers != null) {
                for (Object object : this.mIntegerScaledValueObservers) {
                    IntegerValueChangedCallback integerValueChangedCallback = AbstractRangedValueProxy$IntegerScaledValueObserver.access$000((AbstractRangedValueProxy$IntegerScaledValueObserver)object);
                    int n2 = AbstractRangedValueProxy$IntegerScaledValueObserver.access$100((AbstractRangedValueProxy$IntegerScaledValueObserver)object);
                    int n4 = VCg.dOo(Math.round((float)d3 * (float)n2 - 0.5f), 0, n2 - 1);
                    integerValueChangedCallback.valueChanged(n4);
                }
            }
        }
        if (d2 != d4 && this.mRawValueCallbacks != null) {
            for (Object object : this.mRawValueCallbacks) {
                object.valueChanged(d2);
            }
        }
    }

    public void doTouch(boolean bl2) {
        assert (cOb.JbM(this.isDocumentThread()));
    }
}

