/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.NoteInput$NoteExpression;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject$AllowedCreationTime;
import com.bitwig.flt.control_surface.proxy.MIDIEventFilter;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToDisposeOnControlSurfaceThread;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DirectNoteInput
extends ControlSurfaceObject
implements NoteInput,
ObjectThatWantsToDisposeOnControlSurfaceThread {
    private int mNoteInputIndex;
    private List mFilters;
    private String mName;
    private int mPort;

    public int getNoteInputIndex() {
        return this.mNoteInputIndex;
    }

    public DirectNoteInput(ControlSurfaceObject controlSurfaceObject, int n2, String string, String[] stringArray) {
        super(controlSurfaceObject, ControlSurfaceObject$AllowedCreationTime.INIT);
        this.mPort = n2;
        this.mName = string;
        this.mNoteInputIndex = this.getMidiReceiver().aMA();
        this.mFilters = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            try {
                MIDIEventFilter mIDIEventFilter = new MIDIEventFilter(this.getControlSurface(), this.mPort, string2);
                this.mFilters.add(mIDIEventFilter);
            }
            catch (XuJ xuJ) {
                cOb.dOo.dOo(xuJ);
            }
        }
        this.sendNoteInputMasks();
    }

    @Override
    public void disposeOnControlSurfaceThread() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        try {
            assert (cOb.aMA(this.mNoteInputIndex >= 0));
            this.getMidiReceiver().dOo(this.mNoteInputIndex);
            this.mNoteInputIndex = -1;
        }
        catch (IOException iOException) {
            cOb.dOo.dOo(iOException);
        }
    }

    private void sendNoteInputMasks() {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        int n2 = this.mFilters.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n4 = 0;
        for (MIDIEventFilter mIDIEventFilter : this.mFilters) {
            nArray[n4] = mIDIEventFilter.getCheckMask();
            nArray2[n4] = mIDIEventFilter.getMatchMask();
            ++n4;
        }
        this.getMidiReceiver().dOo(this.mNoteInputIndex, nArray, nArray2);
    }

    private void sendKeyMap(byte[] byArray) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        assert (cOb.JbM(byArray.length == 128));
        this.getMidiReceiver().dOo(this.mNoteInputIndex, byArray);
    }

    private void sendVelocityMap(byte[] byArray) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        assert (cOb.JbM(byArray.length == 128));
        this.getMidiReceiver().aMA(this.mNoteInputIndex, byArray);
    }

    private JHJ getMidiReceiver() {
        return (JHJ)this.getControlSurface().niV().get(this.mPort);
    }

    public int getPort() {
        return this.mPort;
    }

    @Override
    public void setShouldConsumeEvents(boolean bl2) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        try {
            this.getMidiReceiver().dOo(this.mNoteInputIndex, bl2);
        }
        catch (IOException iOException) {
            throw new bNc(iOException);
        }
    }

    private byte[] convertJavaScriptArrayToByteArray(Object[] objectArray) {
        byte[] byArray = new byte[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!(objectArray[i2] instanceof Number)) {
                throw new XuJ("Object in array not instance of Number");
            }
            Number number = (Number)objectArray[i2];
            if (number.intValue() < -128 || number.intValue() > 127) {
                throw new XuJ("Value out of range");
            }
            byArray[i2] = number.byteValue();
        }
        return byArray;
    }

    @Override
    public void setKeyTranslationTable(Object[] objectArray) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new XuJ("Map must have a length of 128");
        }
        try {
            this.sendKeyMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new bNc(iOException);
        }
    }

    @Override
    public void setVelocityTranslationTable(Object[] objectArray) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        if (objectArray == null || objectArray.length != 128) {
            throw new XuJ("Map must have a length of 128");
        }
        try {
            this.sendVelocityMap(this.convertJavaScriptArrayToByteArray(objectArray));
        }
        catch (IOException iOException) {
            throw new bNc(iOException);
        }
    }

    @Override
    public void assignPolyphonicAftertouchToExpression(int n2, NoteInput$NoteExpression noteInput$NoteExpression, int n4) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        try {
            this.getMidiReceiver().dOo(this.mNoteInputIndex, n2, noteInput$NoteExpression, n4);
        }
        catch (IOException iOException) {
            throw new bNc(iOException);
        }
    }

    @Override
    public void setUseExpressiveMidi(boolean bl2, int n2, int n4) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        if (n2 != 0 && n2 != 15) {
            throw new XuJ("baseChannel must be either 0 or 15");
        }
        if (n4 < 0 || n4 > 96) {
            throw new XuJ("pitchBendRange must be between 0 or 96");
        }
        try {
            this.getMidiReceiver().dOo(this.mNoteInputIndex, bl2, n2, n4);
        }
        catch (IOException iOException) {
            throw new bNc(iOException);
        }
    }

    @Override
    public void setUseMultidimensionalPolyphonicExpression(boolean bl2, int n2) {
        this.deprecated(1, 2);
        this.setUseExpressiveMidi(bl2, n2, 48);
    }

    @Override
    public void sendRawMidiEvent(int n2, int n4, int n5) {
        if (this.mNoteInputIndex == -1) {
            return;
        }
        if (n2 < 128 || n2 > 255) {
            throw new XuJ("Status byte out of range");
        }
        if (n4 < 0 || n4 > 127) {
            throw new XuJ("data0 byte out of range");
        }
        if (n5 < 0 || n5 > 127) {
            throw new XuJ("data1 byte out of range");
        }
        try {
            this.getMidiReceiver().dOo(this.mNoteInputIndex, n2, n4, n5);
        }
        catch (IOException iOException) {
            throw new bNc(iOException);
        }
    }

    public String getName() {
        return this.mName;
    }
}

