/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.tgH;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$2;
import com.bitwig.flt.control_surface.proxy.ClipProxy$3;
import com.bitwig.flt.control_surface.proxy.ClipProxy$4;
import com.bitwig.flt.control_surface.proxy.ClipProxy$5;
import com.bitwig.flt.control_surface.proxy.ClipProxy$Step;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.NoteLaneProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.document.core.iface.eFv;
import com.bitwig.ramona.core.ioq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private HUt mPlaybackPositionListener = new ClipProxy$3(this);
    private ioq mHierarchyListener = new ClipProxy$4(this);
    private sYw mSelectionChangeListener = new ClipProxy$5(this);
    private sDD mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private List mSteps;
    private int mBaseKey;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private NoteLaneProxy[] mNoteLanes;
    private final ListValueBankItemTargetUpdater mNoteLanesBankUpdater;
    private SettableBooleanValueProxy mShuffle;
    private RangedValueProxy mAccent;
    private SettableBooleanValueProxy mIsLoopEnabled;
    private BeatTimeProxy mPlayStart;
    private BeatTimeProxy mPlayStop;
    private BeatTimeProxy mLoopStart;
    private BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private Timer mUpdateStepGridTimer;
    private final TrackProxy mTrackSection;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList(2);

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n4) {
        super(controlSurfaceObject);
        int n5;
        this.setKey(string);
        this.mGridHeight = n4;
        this.mGridWidth = n2;
        this.mBaseKey = 0;
        this.mStepGrid = new pt2(this.mStepSize);
        this.mSteps = new ArrayList(this.mGridHeight * this.mGridWidth);
        for (n5 = 0; n5 < n4; ++n5) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mSteps.add(new ClipProxy$Step(this, i2, n5));
            }
        }
        if (this.mGridHeight > 0) {
            this.mNoteLanes = new NoteLaneProxy[this.mGridHeight];
            for (n5 = 0; n5 < this.mGridHeight; ++n5) {
                NoteLaneProxy noteLaneProxy;
                String string2 = string + "/NoteLane" + n5;
                this.mNoteLanes[n5] = noteLaneProxy = new NoteLaneProxy(this, string2, n5);
                this.addChild(noteLaneProxy);
            }
            this.mNoteLanesBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mNoteLanes);
        } else {
            this.mNoteLanes = null;
            this.mNoteLanesBankUpdater = null;
        }
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackSection = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
    }

    @Override
    public Class getTargetType() {
        return bvv.class;
    }

    protected eFv getDocumentFromTarget(bvv bvv2) {
        return bvv2.bke();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        this.scrollToKey(Math.max(128 - this.mGridHeight, this.mBaseKey + this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        this.scrollToKey(Math.min(0, this.mBaseKey - this.mGridHeight));
    }

    @Override
    public void scrollKeysStepUp() {
        this.scrollToKey(Math.max(128 - this.mGridHeight, this.mBaseKey + 1));
    }

    @Override
    public void scrollKeysStepDown() {
        this.scrollToKey(Math.min(0, this.mBaseKey - 1));
    }

    @Override
    public void scrollToKey(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToKey(n2));
    }

    private void doScrollToKey(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null && this.mBaseKey != n2) {
            this.mBaseKey = n2;
            this.updateGrid();
        }
    }

    @Override
    public void scrollToStep(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n2));
    }

    private void doScrollToStep(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null && this.mBaseStep != n2) {
            this.mBaseStep = n2;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null && bvv2.Niy() != null) {
            bvv2.Niy().dOo(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.scrollToStep(this.mBaseStep + this.mGridWidth);
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.scrollToStep(this.mBaseStep - this.mGridWidth);
    }

    @Override
    public void scrollStepsStepForward() {
        this.scrollToStep(this.mBaseStep + 1);
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.scrollToStep(this.mBaseStep - 1);
    }

    @Override
    public void toggleStep(int n2, int n4, int n5) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doToggleStep(n2, n4, n5));
    }

    private void doToggleStep(int n2, int n4, int n5) {
        assert (cOb.JbM(this.isDocumentThread()));
        Nem nem = this.getClip();
        if (nem == null) {
            return;
        }
        bvv bvv2 = (bvv)this.getTarget();
        assert (cOb.JbM(bvv2 != null));
        int n6 = n4 + this.mBaseKey;
        double d2 = this.getTimeForCell(n2);
        double d3 = d2 + this.getStepSize() - 1.0E-4;
        if (n6 >= 0 && n6 < 128) {
            vZh vZh2 = nem.JbM().dOo(n6, false);
            List list = vZh2 != null ? vZh2.JbM(d2, d3) : Collections.EMPTY_LIST;
            bvv2.oZk().KRc();
            if (list.isEmpty()) {
                nem.dOo(d2, this.mStepSize, n6, (float)n5 * 0.007874016f, bvv2.oZk().c1E());
            } else {
                for (RpB rpB : list) {
                    vZh2.aMA(rpB);
                }
            }
        }
    }

    @Override
    public void setStep(int n2, int n4, int n5, double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetStep(n2, n4, n5, d2));
    }

    private void doSetStep(int n2, int n4, int n5, double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        Nem nem = this.getClip();
        if (nem == null) {
            return;
        }
        bvv bvv2 = (bvv)this.getTarget();
        assert (cOb.JbM(bvv2 != null));
        int n6 = n4 + this.mBaseKey;
        double d3 = this.getTimeForCell(n2);
        if (n6 >= 0 && n6 < 128) {
            nem.dOo(d3, d2, n6, (float)n5 * 0.007874016f, bvv2.oZk().c1E());
        }
    }

    @Override
    public void clearStep(int n2, int n4) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doClearStep(n2, n4));
    }

    private void doClearStep(int n2, int n4) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            Nem nem = this.getClip();
            if (nem == null) {
                return;
            }
            int n5 = n4 + this.mBaseKey;
            double d2 = this.getTimeForCell(n2);
            double d3 = d2 + this.getStepSize() - 1.0E-4;
            if (n5 >= 0 && n5 < 128) {
                vZh vZh2 = nem.JbM().dOo(n5, false);
                if (vZh2 != null) {
                    List list = vZh2.JbM(d2, d3);
                    for (PI pI2 : list) {
                        vZh2.aMA(pI2);
                    }
                }
                bvv2.oZk().KRc();
            }
        }
    }

    @Override
    public void clearSteps() {
        this.exec(() -> this.doClearSteps());
    }

    private void doClearSteps() {
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            Nem nem = this.getClip();
            if (nem == null) {
                return;
            }
            nem.aMA().kWi(-1.7976931348623157E308, Double.MAX_VALUE);
            bvv2.oZk().KRc();
        }
    }

    @Override
    public void clearSteps(int n2) {
        this.exec(() -> this.doClearSteps(n2));
    }

    private void doClearSteps(int n2) {
        assert (cOb.kWi(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            vZh vZh2;
            Nem nem = this.getClip();
            if (nem == null) {
                return;
            }
            int n4 = n2 + this.mBaseKey;
            if (n4 >= 0 && n4 < 128 && (vZh2 = nem.JbM().dOo(n4, false)) != null) {
                vZh2.qHb();
            }
        }
    }

    @Override
    public void selectStepContents(int n2, int n4, boolean bl2) {
        this.exec(() -> this.doSelectStepContents(n2, n4, bl2));
    }

    private void doSelectStepContents(int n2, int n4, boolean bl2) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            Nem nem = this.getClip();
            if (nem == null) {
                return;
            }
            int n5 = n4 + this.mBaseKey;
            double d2 = this.getTimeForCell(n2);
            double d3 = d2 + this.getStepSize() - 1.0E-4;
            if (n5 >= 0 && n5 < 128) {
                vZh vZh2 = nem.JbM().dOo(n5, false);
                List list = vZh2 != null ? vZh2.JbM(d2, d3) : Collections.EMPTY_LIST;
                bdb bdb2 = bvv2.oZk();
                if (bl2) {
                    bdb2.KRc();
                }
                for (bkN bkN2 : list) {
                    bdb2.Iqr(bkN2.dOo(0, false));
                }
            }
        }
    }

    @Override
    public void setStepSize(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (d2 <= 0.0) {
            throw new XuJ("step size must be > 0");
        }
        this.exec(() -> this.doSetStepSize(d2));
    }

    private void doSetStepSize(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (this.mStepSize != d2) {
            this.mStepSize = d2;
            this.mStepGrid = new pt2(this.mStepSize);
            if (!this.mHasInvalidatedGrid && bvv2 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateStepGridTimer != null) {
                    this.mUpdateStepGridTimer.cancel();
                }
                this.mUpdateStepGridTimer = new Timer("Update Step Grid");
                this.mUpdateStepGridTimer.schedule((TimerTask)new ClipProxy$1(this), 100L);
            }
        }
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n2) {
        return (double)(this.mBaseStep + n2) * this.getStepSize();
    }

    private int getKeyForY(int n2) {
        return this.mBaseKey + n2;
    }

    private Nem getClip() {
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null && bvv2.Niy() instanceof Nem) {
            return (Nem)bvv2.Niy();
        }
        return null;
    }

    private void invalidateGrid() {
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            tgH.sY3().JbM(new ClipProxy$2(this));
        }
    }

    private void updateGrid() {
        assert (cOb.JbM(this.isDocumentThread()));
        Nem nem = this.getClip();
        bvv bvv2 = (bvv)this.getTarget();
        for (int i2 = 0; i2 < this.mGridWidth; ++i2) {
            double d2 = this.getTimeForCell(i2);
            double d3 = d2 + this.getStepSize() - 1.0E-4;
            List list = Collections.emptyList();
            if (nem != null) {
                assert (cOb.kWi(nem.AWI().q_()));
                list = mRy.dOo(nem.JbM().Iqr(), d2, d3);
            }
            for (int i3 = 0; i3 < this.mGridHeight; ++i3) {
                ClipProxy$Step clipProxy$Step = (ClipProxy$Step)this.mSteps.get(i2 + i3 * this.mGridWidth);
                int n2 = this.getKeyForY(i3);
                int n4 = 0;
                boolean bl2 = false;
                for (RpB rpB : list) {
                    PI pI2 = (PI)rpB;
                    if (pI2.aMA() != n2) continue;
                    int n5 = n4 = pI2.XIh() >= d2 ? 2 : 1;
                    if (!bvv2.oZk().dOo(pI2)) continue;
                    bl2 = true;
                }
                clipProxy$Step.setNoteState(n4);
                clipProxy$Step.setHasSelectedNote(bl2);
            }
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (cOb.JbM(this.isDocumentThread()));
        eFv eFv2 = this.getDocument();
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null && eFv2 != null) {
            pne pne2 = bvv2.Niy();
            KYr kYr = (KYr)pne2.kWi(KYr.class);
            if (kYr != null) {
                NUG nUG = eFv2.kv().JbM();
                nUG.hOH(kYr);
                nUG.mZr();
                if (nUG.PJN()) {
                    nUG.OaX();
                }
            }
            pne2.BtX();
        }
    }

    @Override
    public void duplicateContent() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            bvv2.Niy().BtX();
        }
    }

    @Override
    public void transpose(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n2));
    }

    private void doTranspose(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            bvv2.Niy().dOo(n2);
        }
    }

    @Override
    public void quantize(double d2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (d2 <= 0.0 || d2 > 1.0) {
            throw new XuJ("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d2));
    }

    private void doQuantize(double d2) {
        assert (cOb.JbM(this.isDocumentThread()));
        bvv bvv2 = (bvv)this.getTarget();
        if (bvv2 != null) {
            bvv2.dOo(d2, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackSection;
    }

    protected void connectToTarget(bvv bvv2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(bvv2 != null));
        pne pne2 = bvv2.Niy();
        JwI jwI = pne2.sY3();
        Nem nem = this.getClip();
        if (nem != null) {
            nem.aMA().JbM(this.mPlaybackPositionListener);
            nem.xyB().dOo(this.mHierarchyListener);
        }
        bvv2.oZk().hkH().dOo(this.mSelectionChangeListener);
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.setTarget(pne2.LRY().L1X());
        }
        this.updateGrid();
        this.mShuffle.setTarget(jwI.pg_());
        this.mAccent.setTarget(jwI.LRY());
        T3T t3T = jwI.hOH();
        this.mPlayStart.setTarget(t3T.bo_().Niy());
        this.mPlayStop.setTarget(t3T.aMA().Niy());
        this.mIsLoopEnabled.setTarget(t3T.XWz());
        this.mLoopStart.setTarget(t3T.hOH().Niy());
        this.mLoopLength.setTarget(t3T.hOH().PuA());
        this.mColor.setTarget(pne2.qHb());
        this.mColor.setEditableValue(pne2.drB());
        if (this.mTrackSection != null) {
            KYr kYr;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackSection.getClipLauncherSlots();
            ZBC zBC = pne2.EZ2();
            this.mTrackSection.setTarget(zBC);
            if (clipLauncherSlotBankProxy != null && (kYr = (KYr)pne2.kWi(KYr.class)) != null) {
                clipLauncherSlotBankProxy.scrollToScene(kYr);
            }
        }
        this.connectObservers(pne2);
    }

    protected void disconnectFromTarget(bvv bvv2) {
        assert (cOb.JbM(bvv2 != null));
        pne pne2 = bvv2.Niy();
        this.disconnectObservers(pne2);
        Nem nem = this.getClip();
        if (this.mTrackSection != null) {
            this.mTrackSection.clearTarget();
        }
        if (nem != null) {
            nem.aMA().kWi(this.mPlaybackPositionListener);
            nem.xyB().aMA(this.mHierarchyListener);
        }
        JwI jwI = pne2.sY3();
        T3T t3T = jwI.hOH();
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.clearTarget();
        }
        bvv2.oZk().hkH().aMA(this.mSelectionChangeListener);
        this.updateGrid();
        this.setPlayingStep(-1);
    }

    private void sendNoteStateToObservers(int n2, int n4, int n5) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.queueCallback(() -> this.notifyStepDataObservers(n2, n4, n5));
    }

    private void notifyStepDataObservers(int n2, int n4, int n5) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        for (StepDataChangedCallback stepDataChangedCallback : this.mStepDataChangedCallbacks) {
            stepDataChangedCallback.stepStateChanged(n2, n4, n5);
        }
    }

    private void setPlayingStep(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(n2 >= -1));
        if (n2 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n2;
            this.mPlayingStep.setIntegerValue(n2);
        }
    }

    static /* synthetic */ void access$000(ClipProxy clipProxy) {
        clipProxy.updateGrid();
    }

    static /* synthetic */ boolean access$102(ClipProxy clipProxy, boolean bl2) {
        clipProxy.mHasInvalidatedGrid = bl2;
        return clipProxy.mHasInvalidatedGrid;
    }

    static /* synthetic */ Timer access$202(ClipProxy clipProxy, Timer timer) {
        clipProxy.mUpdateStepGridTimer = timer;
        return clipProxy.mUpdateStepGridTimer;
    }

    static /* synthetic */ void access$300(ClipProxy clipProxy, int n2, int n4, int n5) {
        clipProxy.sendNoteStateToObservers(n2, n4, n5);
    }

    static /* synthetic */ double access$400(ClipProxy clipProxy) {
        return clipProxy.getStepSize();
    }

    static /* synthetic */ void access$500(ClipProxy clipProxy, int n2) {
        clipProxy.setPlayingStep(n2);
    }

    static /* synthetic */ void access$600(ClipProxy clipProxy) {
        clipProxy.invalidateGrid();
    }
}

