/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.ConnectionEstablishedCallback;
import com.bitwig.extension.callback.DataReceivedCallback;
import com.bitwig.extension.controller.api.Application;
import com.bitwig.extension.controller.api.Arranger;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.DocumentState;
import com.bitwig.extension.controller.api.Groove;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MidiOut;
import com.bitwig.extension.controller.api.Mixer;
import com.bitwig.extension.controller.api.ObjectProxy;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.Project;
import com.bitwig.extension.controller.api.RemoteSocket;
import com.bitwig.extension.controller.api.SceneBank;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;
import com.bitwig.flt.control_surface.proxy.AbstractClipCursorProxy;
import com.bitwig.flt.control_surface.proxy.ApplicationProxy;
import com.bitwig.flt.control_surface.proxy.ArrangerClipCursorProxy;
import com.bitwig.flt.control_surface.proxy.ArrangerSection;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost$1;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost$2;
import com.bitwig.flt.control_surface.proxy.BitwigStudioHost$ScheduledTask;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.CurrentDocumentListener;
import com.bitwig.flt.control_surface.proxy.CursorTrackProxy;
import com.bitwig.flt.control_surface.proxy.DatagramServerSection;
import com.bitwig.flt.control_surface.proxy.DocumentStateProxy;
import com.bitwig.flt.control_surface.proxy.GrooveProxy;
import com.bitwig.flt.control_surface.proxy.LauncherClipCursorProxy;
import com.bitwig.flt.control_surface.proxy.MidiInPort;
import com.bitwig.flt.control_surface.proxy.MidiOutPort;
import com.bitwig.flt.control_surface.proxy.MixerSection;
import com.bitwig.flt.control_surface.proxy.NotificationSettingsObject;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToDisposeOnControlSurfaceThread;
import com.bitwig.flt.control_surface.proxy.ObjectThatWantsToInitAndDisposeOnEventThread;
import com.bitwig.flt.control_surface.proxy.PopupBrowserProxy;
import com.bitwig.flt.control_surface.proxy.PreferencesProxy;
import com.bitwig.flt.control_surface.proxy.ProjectProxy;
import com.bitwig.flt.control_surface.proxy.RemoteConnectionSection;
import com.bitwig.flt.control_surface.proxy.RemoteSocketSection;
import com.bitwig.flt.control_surface.proxy.RootControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.SceneBankProxy;
import com.bitwig.flt.control_surface.proxy.TransportProxy;
import com.bitwig.flt.control_surface.proxy.UserControlBankObject;
import com.bitwig.flt.control_surface.values.AreProxiesEqualsValue;
import com.bitwig.flt.control_surface.values.IntegerValueProxy;
import com.bitwig.flt.document.core.iface.eFv;
import com.bitwig.flt.prefs.wFt;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.nashorn.api.scripting.JSObject;

public class BitwigStudioHost
extends wUQ {
    private static final String DEFAULT_CURSOR_TRACK_ID = "TrackSelection";
    private static final String DEFAULT_CURSOR_TRACK_NAME = "Main Track";
    ArrayList mScheduledTasks = new ArrayList();
    private final List mDocumentListeners = new ArrayList();
    private final MidiIn[] mMidiInPorts;
    private final MidiOut[] mMidiOutPorts;
    private final Ljv mControlSurface;
    private eFv mDocument;
    private BXH mDocumentState;
    private final PreferencesProxy mPreferencesProxy;
    private final DocumentStateProxy mDocumentStateProxy;
    private DatagramSocket mDatagramSendSocket;
    private ProjectProxy mProjectSection;
    private final NotificationSettingsObject mNotificationSettings;
    private final List mObjectsToDisposeOnControlSurfaceThread = new ArrayList();
    private final List mObjectsToInitAndDisposeOnEventThread = new ArrayList();
    private final RootControlSurfaceObject mRoot = new RootControlSurfaceObject(this);
    private PopupBrowserProxy mPopupBrowserProxy;
    private final IntegerValueProxy mTimeSignatureNumerator;
    private final IntegerValueProxy mTimeSignatureDenominator;
    private final IntegerValueProxy mTimeSignatureTickRate;
    private final boolean mHasBeenConstructed;
    private final List mCursorTrackProxies = new ArrayList(3);
    private final Map mKeyToObjectMap = new HashMap();
    private final List mAreProxiesEqualsValue = new ArrayList(5);

    public BitwigStudioHost(Ljv ljv2, omQ omQ2) {
        super(omQ2);
        int n2;
        this.mControlSurface = ljv2;
        int n4 = omQ2.sY3();
        this.mMidiInPorts = new MidiIn[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            this.mMidiInPorts[n2] = new MidiInPort((ControlSurfaceObject)this.mRoot, n2);
        }
        n2 = omQ2.pwJ();
        this.mMidiOutPorts = new MidiOut[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mMidiOutPorts[i2] = new MidiOutPort((ControlSurfaceObject)this.mRoot, i2);
        }
        this.mPreferencesProxy = new PreferencesProxy(this.mRoot);
        this.mDocumentStateProxy = new DocumentStateProxy(this.mRoot);
        this.mNotificationSettings = new NotificationSettingsObject(this.mRoot);
        this.mTimeSignatureNumerator = new IntegerValueProxy((ControlSurfaceObject)this.mRoot, 4);
        this.mTimeSignatureDenominator = new IntegerValueProxy((ControlSurfaceObject)this.mRoot, 4);
        this.mTimeSignatureTickRate = new IntegerValueProxy((ControlSurfaceObject)this.mRoot, 16);
        this.mTimeSignatureNumerator.markInterested();
        this.mTimeSignatureDenominator.markInterested();
        this.mTimeSignatureTickRate.markInterested();
        this.mHasBeenConstructed = true;
    }

    @Override
    public void newSince(int n2) {
        if (this.mHasBeenConstructed) {
            super.newSince(n2);
        }
    }

    protected final boolean isControlSurfaceThread() {
        return this.mControlSurface.pwJ();
    }

    protected final boolean isDocumentThread() {
        return this.mControlSurface.QbZ();
    }

    public Ljv getControlSurface() {
        return this.mControlSurface;
    }

    @Override
    protected void driverDidSomethingWrong(pzW pzW2, XuJ xuJ) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.mControlSurface.dOo(xuJ);
    }

    @Override
    protected void driverCrashed(pzW pzW2, Throwable throwable) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.mControlSurface.dOo(throwable);
    }

    public RootControlSurfaceObject getRoot() {
        return this.mRoot;
    }

    @Override
    public Project getProject() {
        this.checkIfAllowedToCreateSection();
        if (this.mProjectSection == null) {
            this.mProjectSection = new ProjectProxy(this.mRoot);
        }
        return this.mProjectSection;
    }

    @Override
    public Transport createTransport() {
        this.checkIfAllowedToCreateSection();
        TransportProxy transportProxy = new TransportProxy(this.mRoot);
        return transportProxy;
    }

    @Override
    public Groove createGroove() {
        this.checkIfAllowedToCreateSection();
        GrooveProxy grooveProxy = new GrooveProxy(this.mRoot);
        return grooveProxy;
    }

    @Override
    public Application createApplication() {
        this.checkIfAllowedToCreateSection();
        ApplicationProxy applicationProxy = new ApplicationProxy(this.mRoot);
        return applicationProxy;
    }

    @Override
    public Arranger createArranger() {
        return this.createArranger(-1);
    }

    @Override
    public Arranger createArranger(int n2) {
        this.checkIfAllowedToCreateSection();
        ArrangerSection arrangerSection = new ArrangerSection(this.mRoot, "", n2);
        return arrangerSection;
    }

    @Override
    public Mixer createMixer() {
        return this.createMixer(null, -1);
    }

    @Override
    public Mixer createMixer(String string) {
        return this.createMixer(string, -1);
    }

    @Override
    public Mixer createMixer(int n2) {
        return this.createMixer(null, n2);
    }

    @Override
    public Mixer createMixer(String string, int n2) {
        this.checkIfAllowedToCreateSection();
        MixerSection mixerSection = new MixerSection(this.mRoot, string, n2);
        return mixerSection;
    }

    @Override
    @Deprecated
    public TrackBank createTrackBank(int n2, int n4, int n5) {
        return this.createTrackBank(n2, n4, n5, true);
    }

    @Override
    public TrackBank createTrackBank(int n2, int n4, int n5, boolean bl2) {
        return this.getProject().getShownTopLevelTrackGroup().createTrackBank(n2, n4, n5, bl2);
    }

    @Override
    public TrackBank createMainTrackBank(int n2, int n4, int n5) {
        return this.getProject().getShownTopLevelTrackGroup().createMainTrackBank(n2, n4, n5, true);
    }

    @Override
    public TrackBank createEffectTrackBank(int n2, int n4) {
        return this.getProject().getShownTopLevelTrackGroup().createEffectTrackBank(n2, n4, true);
    }

    @Override
    public MasterTrack createMasterTrack(int n2) {
        return this.getProject().getRootTrackGroup().createMasterTrack(n2);
    }

    @Override
    public CursorTrackProxy createCursorTrack(int n2, int n4) {
        return this.createCursorTrack(DEFAULT_CURSOR_TRACK_ID, DEFAULT_CURSOR_TRACK_NAME, n2, n4, true);
    }

    @Override
    public CursorTrackProxy createArrangerCursorTrack(int n2, int n4) {
        return this.createTrackSelection(null, true, n2, n4);
    }

    public CursorTrackProxy createEditorTrackSelection(boolean bl2, int n2, int n4) {
        return this.createTrackSelection(null, bl2, n2, n4);
    }

    public CursorTrackProxy createTrackSelection(String string, boolean bl2, int n2, int n4) {
        return this.createCursorTrack(string, n2, n4);
    }

    @Override
    public CursorTrackProxy createCursorTrack(String string, int n2, int n4) {
        this.deprecated(1, 2, "Use createCursorTrack specifying id, name, numSends, numScenes, and if should follow selection instead");
        String string2 = string;
        boolean bl2 = false;
        if (string == null || string.isEmpty()) {
            string = DEFAULT_CURSOR_TRACK_ID;
            string2 = DEFAULT_CURSOR_TRACK_NAME;
            bl2 = true;
        }
        return this.createCursorTrack(string, string2, n2, n4, bl2);
    }

    @Override
    public CursorTrackProxy createCursorTrack(String string, String string2, int n2, int n4, boolean bl2) {
        BitwigStudioHost.notEmpty(string, "id");
        BitwigStudioHost.notEmpty(string2, "name");
        BitwigStudioHost.atLeast(n2, 0, "numSends");
        BitwigStudioHost.atLeast(n4, 0, "numScenes");
        for (CursorTrackProxy cursorTrackProxy : this.mCursorTrackProxies) {
            if (!cursorTrackProxy.getCursorId().equals(string)) continue;
            if (cursorTrackProxy.getNumSends() == n2 && cursorTrackProxy.getNumScenes() == n4) {
                return cursorTrackProxy;
            }
            this.deprecated(1, 2, "CursorTrack already created with id " + string + " but with different number of sends or scenes");
        }
        CursorTrackProxy cursorTrackProxy = new CursorTrackProxy(this.mRoot, string, string2, n2, n4, bl2);
        this.mCursorTrackProxies.add(cursorTrackProxy);
        return cursorTrackProxy;
    }

    @Override
    public AbstractClipCursorProxy createCursorClip(int n2, int n4) {
        return this.createLauncherCursorClip(n2, n4);
    }

    @Override
    public ArrangerClipCursorProxy createArrangerCursorClip(int n2, int n4) {
        this.checkIfAllowedToCreateSection();
        ArrangerClipCursorProxy arrangerClipCursorProxy = new ArrangerClipCursorProxy(this.mRoot, n2, n4);
        return arrangerClipCursorProxy;
    }

    @Override
    public LauncherClipCursorProxy createLauncherCursorClip(int n2, int n4) {
        this.checkIfAllowedToCreateSection();
        LauncherClipCursorProxy launcherClipCursorProxy = new LauncherClipCursorProxy(this.mRoot, n2, n4);
        return launcherClipCursorProxy;
    }

    @Override
    public SceneBank createSceneBank(int n2) {
        SceneBankProxy sceneBankProxy = new SceneBankProxy((ControlSurfaceObject)this.mRoot, n2);
        return sceneBankProxy;
    }

    @Override
    public UserControlBankObject createUserControls(int n2) {
        UserControlBankObject userControlBankObject = new UserControlBankObject((ControlSurfaceObject)this.mRoot, n2);
        return userControlBankObject;
    }

    @Override
    public CursorDevice createCursorDevice() {
        return this.createEditorDeviceSelection(true);
    }

    @Override
    public CursorDevice createEditorCursorDevice() {
        this.deprecated(1, 2, "Use CursorTrack.createCursorDevice()");
        return this.createEditorCursorDevice(0);
    }

    @Override
    public CursorDevice createEditorCursorDevice(int n2) {
        this.deprecated(1, 2, "Use CursorTrack.createCursorDevice()");
        CursorTrackProxy cursorTrackProxy = this.createCursorTrack(n2, 0);
        return cursorTrackProxy.createCursorDevice(null);
    }

    @Deprecated
    public CursorDevice createEditorDeviceSelection(boolean bl2) {
        return this.createEditorCursorDevice();
    }

    @Override
    public Preferences getPreferences() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (this.mPreferencesProxy == null) {
            // empty if block
        }
        return this.mPreferencesProxy;
    }

    @Override
    public DocumentState getDocumentState() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        return this.mDocumentStateProxy;
    }

    public void crashApplicationDueToBadEvent() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.mDocumentStateProxy.crashApplicationDueToBadEvent();
    }

    private void checkIfAllowedToCreateSection() {
        if (!this.mControlSurface.L1X()) {
            throw new XuJ("Trying to create section outside of init().");
        }
    }

    @Override
    public String getHostVendor() {
        return "Bitwig";
    }

    @Override
    public String getHostProduct() {
        return "Bitwig Studio";
    }

    @Override
    public String getHostVersion() {
        return "2.2.2";
    }

    @Override
    public void initMidiPorts(int n2, int n4) {
        this.mControlSurface.dOo(n2, n4);
    }

    @Override
    public void println(String string) {
        this.mControlSurface.dOo(string != null ? V1S.dOo(string, '?') : "null");
    }

    @Override
    public void errorln(String string) {
        this.mControlSurface.aMA(string != null ? V1S.dOo(string, '?') : "null");
    }

    @Override
    public void showPopupNotification(String string) {
        if (string != null) {
            this.mControlSurface.JbM(string);
        }
    }

    @Override
    public RemoteSocket createRemoteConnection(String string, int n2) {
        this.checkIfAllowedToCreateSection();
        RemoteSocketSection remoteSocketSection = new RemoteSocketSection(this.mRoot, string, n2);
        return remoteSocketSection;
    }

    @Override
    public void connectToRemoteHost(String string, int n2, ConnectionEstablishedCallback connectionEstablishedCallback) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        try {
            Socket socket = new Socket(string, n2);
            RemoteConnectionSection remoteConnectionSection = new RemoteConnectionSection((ControlSurfaceObject)this.mRoot, socket);
            Object[] objectArray = new Object[]{remoteConnectionSection};
            this.mControlSurface.aMA(() -> connectionEstablishedCallback.connectionEstablished(remoteConnectionSection));
        }
        catch (IOException iOException) {
            cOb.dOo.dOo(iOException);
        }
    }

    @Override
    public void sendDatagramPacket(String string, int n2, byte[] byArray) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        try {
            if (this.mDatagramSendSocket == null) {
                this.mDatagramSendSocket = new DatagramSocket();
            }
            InetAddress inetAddress = InetAddress.getByName(string);
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n2);
            this.mDatagramSendSocket.send(datagramPacket);
        }
        catch (UnknownHostException unknownHostException) {
            throw new XuJ(unknownHostException.getLocalizedMessage());
        }
        catch (SocketException socketException) {
            throw new XuJ(socketException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            throw new XuJ(iOException.getLocalizedMessage());
        }
    }

    @Override
    public boolean addDatagramPacketObserver(String string, int n2, DataReceivedCallback dataReceivedCallback) {
        try {
            DatagramServerSection datagramServerSection = new DatagramServerSection(this.mRoot, string, n2, dataReceivedCallback);
            return true;
        }
        catch (SocketException socketException) {
            cOb.dOo.dOo(socketException);
            return false;
        }
    }

    @Override
    public MidiIn getMidiInPort(int n2) {
        if (n2 < 0 || n2 >= this.mMidiInPorts.length) {
            throw new XuJ("Invalid MIDI port index.");
        }
        return this.mMidiInPorts[n2];
    }

    @Override
    public MidiOut getMidiOutPort(int n2) {
        if (n2 < 0 || n2 >= this.mMidiOutPorts.length) {
            throw new XuJ("Invalid MIDI port index.");
        }
        return this.mMidiOutPorts[n2];
    }

    @Override
    public PopupBrowserProxy createPopupBrowser() {
        if (this.mPopupBrowserProxy != null) {
            throw new XuJ("Driver can only create one PopupBrowser");
        }
        this.mPopupBrowserProxy = new PopupBrowserProxy(this.mRoot);
        return this.mPopupBrowserProxy;
    }

    @Override
    public void scheduleTask(JSObject jSObject, Object[] objectArray, long l2) {
        this.deprecated(1, 2, "Use scheduleTask(runnable, delay) instead");
        BitwigStudioHost$1 bitwigStudioHost$1 = new BitwigStudioHost$1(this, jSObject, objectArray);
        this.mScheduledTasks.add(new BitwigStudioHost$ScheduledTask(this, bitwigStudioHost$1, l2));
    }

    @Override
    public void scheduleTask(Runnable runnable, long l2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.newSince(2);
        this.mScheduledTasks.add(new BitwigStudioHost$ScheduledTask(this, runnable, l2));
    }

    public void processScheduledTasks(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        ArrayList<BitwigStudioHost$ScheduledTask> arrayList = null;
        for (BitwigStudioHost$ScheduledTask bitwigStudioHost$ScheduledTask : this.mScheduledTasks) {
            boolean bl2 = bitwigStudioHost$ScheduledTask.process(n2);
            if (!bl2) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<BitwigStudioHost$ScheduledTask>();
            }
            arrayList.add(bitwigStudioHost$ScheduledTask);
        }
        if (arrayList != null) {
            this.mScheduledTasks.removeAll(arrayList);
        }
    }

    @Override
    public void requestFlush() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.newSince(2);
        this.mControlSurface.Iqr();
    }

    public IntegerValueProxy getTimeSignatureNumerator() {
        return this.mTimeSignatureNumerator;
    }

    public IntegerValueProxy getTimeSignatureDenominator() {
        return this.mTimeSignatureDenominator;
    }

    public IntegerValueProxy getTimeSignatureTickRate() {
        return this.mTimeSignatureTickRate;
    }

    public void connectToDocument(eFv eFv2, BXH bXH2, wFt wFt2) {
        assert (cOb.JbM(eFv2 != null));
        assert (cOb.JbM(bXH2 != null));
        assert (cOb.JbM(wFt2 != null));
        assert (cOb.JbM(this.mDocument == null));
        assert (cOb.aMA(this.mDocumentState == null));
        assert (cOb.JbM(eFv2.RVn()));
        assert (cOb.JbM(this.isDocumentThread()));
        this.mDocument = eFv2;
        this.mDocumentState = bXH2;
        db2 db22 = eFv2.XIh();
        MOA mOA = db22.sY3();
        this.mTimeSignatureNumerator.setTarget(mOA.JbM());
        this.mTimeSignatureDenominator.setTarget(mOA.Iqr());
        this.mTimeSignatureTickRate.setTarget(mOA.L1X());
        for (CurrentDocumentListener currentDocumentListener : this.mDocumentListeners) {
            currentDocumentListener.setCurrentDocument(eFv2);
        }
    }

    public void disconnectFromDocument(eFv eFv2) {
        assert (cOb.JbM(eFv2 != null));
        assert (cOb.JbM(this.mDocument == eFv2));
        assert (cOb.aMA(this.mDocumentState != null));
        assert (cOb.aMA(eFv2.AWI().q_()));
        assert (cOb.JbM(this.mDocument == eFv2));
        this.mTimeSignatureNumerator.clearTarget();
        this.mTimeSignatureDenominator.clearTarget();
        this.mTimeSignatureTickRate.clearTarget();
        this.mDocument = null;
        this.mDocumentState = null;
        for (CurrentDocumentListener currentDocumentListener : this.mDocumentListeners) {
            currentDocumentListener.setCurrentDocument(null);
        }
    }

    public void initOnEventThread() {
        assert (cOb.JbM(this.isDocumentThread()));
        for (ObjectThatWantsToInitAndDisposeOnEventThread objectThatWantsToInitAndDisposeOnEventThread : this.mObjectsToInitAndDisposeOnEventThread) {
            objectThatWantsToInitAndDisposeOnEventThread.initOnEventThread();
        }
    }

    public void disposeOnEventThread() {
        assert (cOb.JbM(this.isDocumentThread()));
        for (ObjectThatWantsToInitAndDisposeOnEventThread objectThatWantsToInitAndDisposeOnEventThread : this.mObjectsToInitAndDisposeOnEventThread) {
            objectThatWantsToInitAndDisposeOnEventThread.disposeOnEventThread();
        }
    }

    public void disposeOnControlSurfaceThread() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        for (ObjectThatWantsToDisposeOnControlSurfaceThread objectThatWantsToDisposeOnControlSurfaceThread : this.mObjectsToDisposeOnControlSurfaceThread) {
            try {
                objectThatWantsToDisposeOnControlSurfaceThread.disposeOnControlSurfaceThread();
            }
            catch (Throwable throwable) {
                cOb.dOo.dOo(throwable);
            }
        }
        if (this.mDatagramSendSocket != null) {
            try {
                this.mDatagramSendSocket.close();
            }
            catch (Throwable throwable) {
                cOb.dOo.dOo(throwable);
            }
            this.mDatagramSendSocket = null;
        }
        assert (cOb.aMA(this.mDocument == null));
        assert (cOb.aMA(this.mDocumentState == null));
    }

    @Override
    public NotificationSettingsObject getNotificationSettings() {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        return this.mNotificationSettings;
    }

    public void controlSurfaceObjectCreated(ControlSurfaceObject controlSurfaceObject) {
        ControlSurfaceProxy controlSurfaceProxy;
        assert (cOb.JbM(controlSurfaceObject != null));
        assert (cOb.JbM(controlSurfaceObject.getHost() == this));
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(controlSurfaceObject.getKey() == null));
        if (controlSurfaceObject instanceof ObjectThatWantsToDisposeOnControlSurfaceThread) {
            this.mObjectsToDisposeOnControlSurfaceThread.add((ObjectThatWantsToDisposeOnControlSurfaceThread)((Object)controlSurfaceObject));
        }
        if (controlSurfaceObject instanceof CurrentDocumentListener) {
            this.mDocumentListeners.add((CurrentDocumentListener)((Object)controlSurfaceObject));
        } else if (controlSurfaceObject instanceof ObjectProxy && (controlSurfaceProxy = (ControlSurfaceProxy)controlSurfaceObject).getTargetType() == eFv.class) {
            this.mDocumentListeners.add(new BitwigStudioHost$2(this, controlSurfaceProxy));
        }
        if (controlSurfaceObject instanceof ObjectThatWantsToInitAndDisposeOnEventThread) {
            this.mObjectsToInitAndDisposeOnEventThread.add((ObjectThatWantsToInitAndDisposeOnEventThread)((Object)controlSurfaceObject));
        }
    }

    public ControlSurfaceObject getObjectWithKey(String string) {
        assert (cOb.JbM(string != null));
        assert (cOb.JbM(!string.isEmpty()));
        return (ControlSurfaceObject)this.mKeyToObjectMap.get(string);
    }

    public void rememberKey(ControlSurfaceObject controlSurfaceObject) {
        assert (cOb.JbM(this.mControlSurface.L1X()));
        String string = controlSurfaceObject.getKey();
        assert (cOb.JbM(string != null && !string.isEmpty()));
        assert (cOb.JbM(!this.mKeyToObjectMap.containsKey(string)));
        this.mKeyToObjectMap.put(string, controlSurfaceObject);
    }

    public BooleanValue createAreProxiesEqualValue(ControlSurfaceProxy controlSurfaceProxy, ControlSurfaceProxy controlSurfaceProxy2) {
        assert (cOb.JbM(controlSurfaceProxy != null));
        BitwigStudioHost.notNull(controlSurfaceProxy2, "other");
        this.newSince(3);
        this.mControlSurface.hOH();
        ControlSurfaceProxy controlSurfaceProxy3 = controlSurfaceProxy.getDeepestProxy();
        ControlSurfaceProxy controlSurfaceProxy4 = controlSurfaceProxy2.getDeepestProxy();
        assert (cOb.JbM(controlSurfaceProxy3 != null));
        assert (cOb.JbM(controlSurfaceProxy4 != null));
        if (controlSurfaceProxy3 == controlSurfaceProxy4) {
            throw new XuJ("These proxies always refer to the same target");
        }
        Class clazz = controlSurfaceProxy3.getTargetType();
        Class clazz2 = controlSurfaceProxy4.getTargetType();
        assert (cOb.JbM(clazz != null));
        assert (cOb.JbM(clazz2 != null));
        if (!clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz)) {
            throw new XuJ("These proxies can never refer be equal as they are of different types");
        }
        for (AreProxiesEqualsValue areProxiesEqualsValue : this.mAreProxiesEqualsValue) {
            if ((areProxiesEqualsValue.getProxy1() != controlSurfaceProxy3 || areProxiesEqualsValue.getProxy2() != controlSurfaceProxy4) && (areProxiesEqualsValue.getProxy1() != controlSurfaceProxy4 || areProxiesEqualsValue.getProxy2() != controlSurfaceProxy3)) continue;
            return areProxiesEqualsValue;
        }
        AreProxiesEqualsValue areProxiesEqualsValue = new AreProxiesEqualsValue(controlSurfaceProxy3, controlSurfaceProxy4);
        this.mAreProxiesEqualsValue.add(areProxiesEqualsValue);
        return areProxiesEqualsValue;
    }

    void targetChanged(ControlSurfaceProxy controlSurfaceProxy, Object object) {
        assert (cOb.JbM(controlSurfaceProxy != null));
        assert (cOb.JbM(controlSurfaceProxy.getHost() == this));
        assert (cOb.JbM(this.isDocumentThread()));
        for (AreProxiesEqualsValue areProxiesEqualsValue : this.mAreProxiesEqualsValue) {
            if (areProxiesEqualsValue.getProxy1() != controlSurfaceProxy && areProxiesEqualsValue.getProxy2() != controlSurfaceProxy) continue;
            areProxiesEqualsValue.update();
        }
    }

    static /* synthetic */ Ljv access$000(BitwigStudioHost bitwigStudioHost) {
        return bitwigStudioHost.mControlSurface;
    }
}

