/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.ramona.core.VSu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BankItemTargetUpdater
extends ControlSurfaceProxy
implements YgR {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private boolean mHasScheduledUpdate;
    private VSu mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n2) {
        super(controlSurfaceObject);
        assert (cOb.JbM(controlSurfaceProxyArray != null));
        assert (cOb.JbM(n2 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n2;
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    public int getSizeOfBank() {
        return this.mItemProxies.length;
    }

    public ControlSurfaceProxy getItemAt(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n2);
    }

    public void scrollTo(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        this.postEvent(new XP(this, Math.max(0, n2), true));
    }

    public void doScrollTo(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(n2 >= 0));
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n2);
        } else {
            this.doScrollToImpl(n2);
        }
    }

    protected int quantizePosition(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        int n4 = this.mItemProxies.length;
        int n5 = n4 < this.mScrollPositionThatPageShouldAlignTo ? this.mScrollPositionThatPageShouldAlignTo % n4 : 0;
        int n6 = (n2 - n5) / n4 * n4 + n5;
        int n7 = this.mListItemCount.getValue();
        if (n6 < this.mScrollPosition.getValue() - n4) {
            n6 += n4;
        }
        int n8 = (n7 - 1) / n4 * n4;
        return VCg.dOo(n6, 0, n8);
    }

    private void doScrollToImpl(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        int n4 = VCg.dOo(n2, 0, Math.max(0, this.mListItemCount.getValue() - this.mItemProxies.length));
        List list = this.getList();
        int n5 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n6 = n4 + i2;
            if (n6 < list.size()) {
                object = (VSu)list.get(n6);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n5 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n6);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                super.doScrollToImpl(n4);
            }
        }
        this.mScrollPosition.setIntegerValue(n4);
        if (n5 >= 0) {
            this.mCursorIndex.setIntegerValue(n5);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n4 + this.mItemProxies.length < list.size());
        this.mCanScrollBackwards.setBoolValue(n4 > 0);
    }

    public void scrollBy(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.postEvent(new XP(this, n2, false));
        }
    }

    public void doScrollBy(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n2));
    }

    public void scrollByPages(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.exec(() -> this.doScrollByPages(n2));
        }
    }

    private void doScrollByPages(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        this.doScrollBy(n2 * this.mItemProxies.length);
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public SettableIntegerValue getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (cOb.JbM(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public void listChanged() {
        assert (cOb.JbM(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::update);
        }
    }

    private void update() {
        assert (cOb.JbM(this.isDocumentThread()));
        List list = this.getList();
        this.update(list);
        this.mHasScheduledUpdate = false;
    }

    @Override
    protected void connectToTarget(Object object) {
        this.update();
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getList() {
        assert (cOb.JbM(this.isDocumentThread()));
        Object object = this.getTarget();
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        return this.calculateList(object);
    }

    protected abstract List calculateList(Object var1);

    protected void update(List list) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(list != null));
        int n2 = list.size() <= this.mItemProxies.length ? 0 : this.determineNewOffset(list);
        assert (cOb.JbM(n2 >= 0));
        assert (cOb.JbM(this.mItemProxies.length < list.size() ? n2 + this.mItemProxies.length <= list.size() : n2 == 0));
        int n4 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n5 = n2 + i2;
            if (n5 < list.size()) {
                object = (VSu)list.get(n5);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && object == this.mCursor) {
                    n4 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n5);
        }
        Object object = this.getTarget();
        if (object != null) {
            this.mScrollPosition.setIntegerValue(n2);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n2 + this.mItemProxies.length < list.size());
            this.mCanScrollBackwards.setBoolValue(n2 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n4 >= 0) {
            this.mCursorIndex.setIntegerValue(n4);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (cOb.JbM(list.size() >= this.mItemProxies.length));
        assert (cOb.JbM(this.isDocumentThread()));
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            int n2;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            VSu vSu = (VSu)controlSurfaceProxy.getTarget();
            if (vSu == null || (n2 = list.indexOf(vSu)) < 0) continue;
            return VCg.dOo(n2, 0, list.size() - this.mItemProxies.length);
        }
        return VCg.dOo(this.mScrollPosition.getValue(), 0, list.size() - this.mItemProxies.length);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (cOb.JbM(bankItemTargetUpdater != null));
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (cOb.JbM(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (cOb.JbM(bankItemTargetUpdater != null));
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(this.isInitializingDriver()));
        assert (cOb.JbM(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (cOb.JbM(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (cOb.JbM(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public VSu getFirstItem(VSu vSu) {
        assert (cOb.JbM(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (VSu)list.get(0);
        }
        return null;
    }

    @Override
    public VSu getLastItem(VSu vSu) {
        assert (cOb.JbM(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (VSu)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public VSu getPreviousItem(VSu vSu) {
        assert (cOb.JbM(this.isDocumentThread()));
        List list = this.getList();
        if (vSu == null) {
            if (!list.isEmpty()) {
                return (VSu)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(vSu);
        if (n2 > 0) {
            return (VSu)list.get(n2 - 1);
        }
        return null;
    }

    @Override
    public VSu getNextItem(VSu vSu) {
        assert (cOb.JbM(this.isDocumentThread()));
        List list = this.getList();
        if (vSu == null) {
            if (!list.isEmpty()) {
                return (VSu)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(vSu);
        if (n2 + 1 < list.size()) {
            return (VSu)list.get(n2 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(VSu vSu) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(this.mCursorProxyToFollow != null));
        this.mCursor = vSu;
        if (vSu != null) {
            this.doScrollToItem(vSu);
            int n2 = -1;
            for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
                ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
                VSu vSu2 = (VSu)controlSurfaceProxy.getTarget();
                if (vSu2 != vSu) continue;
                n2 = i2;
                break;
            }
            if (n2 >= 0) {
                this.mCursorIndex.setIntegerValue(n2);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(VSu vSu) {
        int n2;
        assert (cOb.JbM(vSu != null));
        assert (cOb.JbM(this.isDocumentThread()));
        List list = this.getList();
        int n4 = list.indexOf(vSu);
        if (n4 >= 0 && (n4 < (n2 = this.mScrollPosition.getValue()) || n4 >= n2 + this.mItemProxies.length)) {
            int n5 = this.quantizePosition(n4);
            assert (cOb.JbM(n4 >= n5 && n4 < n5 + this.mItemProxies.length));
            this.doScrollTo(n5);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new XuJ("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (cOb.JbM(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        assert (cOb.JbM(n2 >= 0 && n2 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new XuJ("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n2));
    }

    private void doMoveCursorToIndex(int n2) {
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(n2 >= 0 && n2 < this.getSizeOfBank()));
        assert (cOb.JbM(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n2];
        VSu vSu = (VSu)controlSurfaceProxy.getTarget();
        if (vSu != null) {
            this.mCursorProxyToFollow.doSelect(vSu);
        }
    }

    protected void moveCursorIndexBy(int n2) {
        assert (cOb.JbM(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new XuJ("This bank is not following any cursor");
        }
        if (n2 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n2));
        }
    }

    private void doMoveCursorIndexBy(int n2) {
        int n4;
        assert (cOb.JbM(this.isDocumentThread()));
        assert (cOb.JbM(n2 != 0));
        assert (cOb.JbM(this.mCursorProxyToFollow != null));
        int n5 = this.mCursorIndex.getValue();
        assert (cOb.JbM(n5 >= 0 && n5 < this.getSizeOfBank() || n5 == -1));
        if (n5 >= 0 && n5 < this.getSizeOfBank() && (n4 = n5 + n2) >= 0 && n4 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n4);
        }
    }
}

