/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing;

import com.bitwig.flt.app.nQS;
import com.bitwig.flt.app.rQK;
import com.bitwig.flt.app.tUz;
import com.bitwig.flt.app.testing.BitwigApplicationTest;
import com.bitwig.flt.device.Bpx;
import com.bitwig.flt.document.core.master.device.DeviceNotFoundException;
import com.bitwig.flt.document.core.master.device.reV;
import com.bitwig.flt.document.core.master.device.zci;
import java.io.File;
import java.util.EnumSet;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class BitwigGeneratedProjectTest
extends BitwigApplicationTest {
    private KIE mDocument;

    protected KIE createProject(int n2, int n4) {
        if (this.getApplication().a_()) {
            this.doCreateProject(n2, n4);
        } else {
            this.exec(() -> this.doCreateProject(n2, n4));
        }
        return this.mDocument;
    }

    private void doCreateProject(int n2, int n4) {
        this.mDocument = this.getApplication().dOo(n2, n4, EnumSet.noneOf(nQS.class)).JbM();
    }

    protected KIE openProject(File file) {
        this.check(!this.getApplication().a_());
        rQK rQK2 = this.getApplication();
        String string = file.getAbsolutePath();
        EiJ eiJ2 = new EiJ();
        this.asyncExec(() -> rQK2.dOo(string, EnumSet.noneOf(nQS.class), eiJ2));
        try {
            tUz tUz2 = (tUz)eiJ2.dOo(30L, TimeUnit.SECONDS);
            this.mDocument = tUz2.JbM();
            this.mDocument.XWz(true);
        }
        catch (Exception exception) {
            this.fail(exception.getLocalizedMessage());
        }
        this.exec(() -> this.getApplication().aMA(this.getApplication().L1X(this.mDocument)));
        return this.mDocument;
    }

    protected void activateEngine(KIE kIE) {
        rQK rQK2 = this.getApplication();
        assert (cOe.JbM(!rQK2.a_()));
        imO imO2 = new imO();
        this.asyncExec(() -> kIE.aMA(imO2));
        try {
            imO2.dOo(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            this.fail("Could not activate audio engine: " + exception.getLocalizedMessage());
        }
    }

    protected void validateGraph(TMn ... tMnArray) {
        Semaphore semaphore = new Semaphore(0);
        this.exec(() -> this.getApplication().aMA(() -> {
            try {
                if (this.mDocument == null) {
                    this.fail("No document");
                }
                ltx ltx2 = this.mDocument.dOo(HEU.kWi);
                this.checkEquals("containFeedbackLoops", ltx2.dOo(), false);
                for (TMn tMn : tMnArray) {
                    this.check("requiredVertex " + tMn.toString(), ltx2.containsVertex(tMn));
                }
            }
            catch (Exception exception) {
                this.fail("validateGraph failed: " + exception.getLocalizedMessage());
            }
            semaphore.release();
        }));
        try {
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            LOG.dOo(interruptedException);
            this.fail(interruptedException.getLocalizedMessage());
        }
    }

    protected void closeProject() {
        if (this.mDocument == null) {
            return;
        }
        this.exec(() -> {
            tUz tUz2 = this.getApplication().L1X(this.mDocument);
            this.getApplication().dOo(tUz2, false, null, null);
        });
        this.mDocument = null;
    }

    protected xcb createTrack(hrG hrG2) {
        if (this.getApplication().a_()) {
            PfZ pfZ = this.getTrackOrTrackGroupSelection();
            pfZ.dOo(hrG2);
            return (xcb)pfZ.bke();
        }
        xcb[] xcbArray = new xcb[1];
        this.exec(() -> {
            PfZ pfZ = this.getTrackOrTrackGroupSelection();
            pfZ.dOo(hrG2);
            xcbArray[0] = (xcb)pfZ.bke();
        });
        return xcbArray[0];
    }

    protected zci insertDevice(reV reV2, int n2, UUID uUID) {
        Semaphore semaphore = new Semaphore(1);
        HUt hUt = mpO -> {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                LOG.dOo(interruptedException);
            }
        };
        HUt hUt2 = k2w -> semaphore.release();
        this.exec(() -> {
            File file = null;
            try {
                file = this.getApplication().dOo(uUID);
                this.check("fileForDeviceUUID exists", file.isFile());
            }
            catch (DeviceNotFoundException deviceNotFoundException) {
                this.fail(deviceNotFoundException.getLocalizedMessage());
            }
            this.mDocument.VML(hUt);
            this.mDocument.VcV(hUt2);
            reV2.dOo(file.getAbsolutePath(), n2);
        });
        try {
            semaphore.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            LOG.dOo(interruptedException);
            this.fail("Timed out");
        }
        this.exec(() -> {
            this.mDocument.kCt(hUt);
            this.mDocument.V1B(hUt2);
        });
        zci zci2 = (zci)this.getRequired(() -> reV2.JbM(n2));
        this.check(((Bpx)this.getRequired(() -> (Bpx)zci2.eo_())).dOo().equals(uUID));
        return zci2;
    }

    protected void addModulator(zci zci2, UUID uUID) {
        Semaphore semaphore = new Semaphore(1);
        HUt hUt = mpO -> {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                LOG.dOo(interruptedException);
            }
        };
        HUt hUt2 = k2w -> semaphore.release();
        this.exec(() -> {
            File file = null;
            try {
                file = this.getApplication().dOo(uUID);
                this.check("fileForDeviceUUID exists", file.isFile());
            }
            catch (DeviceNotFoundException deviceNotFoundException) {
                this.fail(deviceNotFoundException.getLocalizedMessage());
            }
            this.mDocument.VML(hUt);
            this.mDocument.VcV(hUt2);
            zci2.Sgf().dOo(new String[]{file.getAbsolutePath()}, 0, 0);
        });
        try {
            semaphore.tryAcquire(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            LOG.dOo(interruptedException);
            this.fail("Timed out");
        }
        this.exec(() -> {
            this.mDocument.kCt(hUt);
            this.mDocument.V1B(hUt2);
        });
    }

    protected PfZ getTrackOrTrackGroupSelection() {
        return this.mDocument.byx().dPQ();
    }

    public HwV getMainTrack(int ... nArray) {
        MwQ mwQ;
        HwV hwV = mwQ = this.mDocument.kmL();
        for (int n2 : nArray) {
            hwV = hwV.Mpc(n2);
        }
        return hwV;
    }
}

