/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ControlSurfaceString;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.IntelligentControlSurfaceString;
import com.bitwig.flt.control_surface.values.StringValueProxy$1;
import com.bitwig.flt.control_surface.values.StringValueProxy$2;
import com.bitwig.flt.control_surface.values.ValueProxy;

public class StringValueProxy
extends ValueProxy
implements UNs,
StringValue {
    private ControlSurfaceString mValue;
    private final ControlSurfaceString mDefaultValue;

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.mValue = this.mDefaultValue = this.createControlSurfaceStringValue(string);
    }

    public StringValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, "");
    }

    @Override
    public Class getTargetType() {
        return fUU.class;
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        assert (cOY.HSF(n2 >= 1));
        return this.mValue.getLimited(n2);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new StringValueProxy$1(this, stringValueChangedCallback));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new StringValueProxy$2(this, stringValueChangedCallback, string, n2));
    }

    protected void sendDefaultValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        controlSurfaceStringValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(fUU fUU2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(fUU2 != null));
        fUU2.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(fUU fUU2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(fUU2 != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(this.isActiveOnDocumentThread()));
        fUU2.addListener(this);
        this.updateValue();
    }

    public ControlSurfaceString getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(Se se2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(IYH.rKg(se2.rKg(), this.getTarget())));
        this.updateValue();
    }

    private void updateValue() {
        assert (cOY.HSF(this.isDocumentThread()));
        String string = (String)((fUU)this.getTarget()).getValue();
        assert (cOY.HSF(string != null));
        ControlSurfaceString controlSurfaceString = this.createControlSurfaceStringValue(string);
        assert (cOY.HSF(controlSurfaceString != null));
        this.queueNotifyObservers(controlSurfaceString);
    }

    private void queueNotifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(controlSurfaceString));
    }

    protected ControlSurfaceString createControlSurfaceStringValue(String string) {
        assert (cOY.HSF(this.isDocumentThread() || this.isInitializingDriver()));
        if (string.isEmpty()) {
            return ControlSurfaceString.EMPTY;
        }
        return new IntelligentControlSurfaceString(string);
    }

    private void notifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        if (!controlSurfaceString.equals(this.mValue)) {
            this.mValue = controlSurfaceString;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(controlSurfaceString);
                }
            }
        }
    }

    static /* synthetic */ ControlSurfaceString access$000(StringValueProxy stringValueProxy) {
        return stringValueProxy.mDefaultValue;
    }
}

