/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy;
import com.bitwig.flt.control_surface.values.DocumentNumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.NumberSettingRangedValueTarget;
import com.bitwig.flt.control_surface.values.PreferencesNumberSettingRangedValueTarget;
import com.bitwig.ramona.core.MtY;

public class NumberSetting
extends AbstractRangedValueProxy
implements Setting {
    private final String mCategory;
    private final String mLabel;
    private final double mMinValue;
    private final double mMaxValue;
    private final double mStepResolution;
    private final String mUnit;
    private final double mDefaultValue;
    private vRm mIsEnabled;
    private vRm mIsVisible;
    private boolean mIsEnabledByDefault = true;
    private boolean mIsVisibleByDefault = true;
    private MtY mSetting;

    public NumberSetting(ControlSurfaceObject controlSurfaceObject, String string, String string2, double d3, double d4, double d5, String string3, double d6) {
        super(controlSurfaceObject);
        if (string == null || string.isEmpty()) {
            throw new Q3u("Error: label for setting can't be empty.");
        }
        if (string3 == null) {
            string3 = "";
        }
        this.mLabel = string;
        this.mCategory = string2;
        this.mMinValue = d3;
        this.mMaxValue = d4;
        this.mStepResolution = d5;
        this.mUnit = string3;
        this.mDefaultValue = d6;
        this.setKey("Setting/" + string2 + "/" + string);
    }

    @Override
    protected boolean shouldBeInterestedByDefault() {
        return true;
    }

    @Override
    public Class getTargetType() {
        return NumberSettingRangedValueTarget.class;
    }

    public void connectToSetting(QG qG2) {
        assert (cOY.jWS(this.mSetting == null));
        this.mSetting = qG2;
        this.setTarget(new PreferencesNumberSettingRangedValueTarget(qG2));
        this.connectEnableAndVisibleValues(qG2.Uuf(), qG2.Ckf());
    }

    public void disconnectFromSetting(QG qG2) {
        assert (cOY.jWS(this.mSetting == qG2));
        this.disconnectEnableAndVisibleValues(qG2.Uuf(), qG2.Ckf());
        this.clearTarget();
        this.mSetting = null;
    }

    public void connectToSetting(Lrd lrd) {
        assert (cOY.jWS(this.mSetting == null));
        this.mSetting = lrd;
        this.setTarget(new DocumentNumberSettingRangedValueTarget(lrd));
        this.connectEnableAndVisibleValues(lrd.CqD(), lrd.fh1());
    }

    public void disconnectFromSetting(Lrd lrd) {
        assert (cOY.jWS(this.mSetting == lrd));
        this.disconnectEnableAndVisibleValues(lrd.CqD(), lrd.fh1());
        this.clearTarget();
        this.mSetting = null;
    }

    private void connectEnableAndVisibleValues(vRm vRm2, vRm vRm3) {
        this.mIsEnabled = vRm2;
        this.mIsVisible = vRm3;
    }

    private void disconnectEnableAndVisibleValues(vRm vRm2, vRm vRm3) {
        this.mIsEnabled = null;
        this.mIsVisible = null;
    }

    @Override
    protected double getCurrentValue() {
        double d3 = super.getCurrentValue();
        int n2 = (int)Math.round(d3 / this.mStepResolution);
        return this.mStepResolution * (double)n2;
    }

    @Override
    public String getLabel() {
        return this.mLabel;
    }

    @Override
    public String getCategory() {
        return this.mCategory;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public double getStepResolution() {
        return this.mStepResolution;
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public String getUnit() {
        return this.mUnit;
    }

    @Override
    public void enable() {
        this.setIsEnabled(true);
    }

    @Override
    public void disable() {
        this.setIsEnabled(false);
    }

    @Override
    public void show() {
        this.setIsShown(true);
    }

    @Override
    public void hide() {
        this.setIsShown(false);
    }

    public void setIsEnabled(boolean bl2) {
        if (this.mIsEnabled != null) {
            this.mIsEnabled.setValue(bl2);
        } else {
            this.mIsEnabledByDefault = bl2;
        }
    }

    public void setIsShown(boolean bl2) {
        if (this.mIsVisible != null) {
            this.mIsVisible.setValue(bl2);
        } else {
            this.mIsVisibleByDefault = bl2;
        }
    }

    public boolean isEnabledByDefault() {
        return this.mIsEnabledByDefault;
    }

    public boolean isVisibleByDefault() {
        return this.mIsVisibleByDefault;
    }

    public MtY getSetting() {
        return this.mSetting;
    }
}

