/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.UnassignedValueObserver;
import com.bitwig.flt.control_surface.values.ValueProxy;
import java.util.ArrayList;
import java.util.List;

public class IntegerValueProxy
extends ValueProxy
implements UNs,
IntegerValue {
    private int mValue;
    private final int mDefaultValue;
    private List mUnassignedObservers;

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.mValue = n2;
        this.mDefaultValue = n2;
    }

    public IntegerValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0);
    }

    @Override
    public Class getTargetType() {
        return OWP.class;
    }

    @Override
    public int get() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public int getControlSurfaceValue() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.doAddValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addValueObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        if (n2 == this.mDefaultValue) {
            this.addValueObserver(integerValueChangedCallback);
        } else {
            this.checkIsInitializingDriver();
            this.notNull(integerValueChangedCallback, "callback");
            this.doMarkInterested();
            if (this.mUnassignedObservers == null) {
                this.mUnassignedObservers = new ArrayList(2);
            }
            this.mUnassignedObservers.add(new UnassignedValueObserver(integerValueChangedCallback, n2));
        }
    }

    protected void sendDefaultValue(IntegerValueChangedCallback integerValueChangedCallback) {
        integerValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(OWP oWP) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(oWP != null));
        oWP.removeListener(this);
        this.queueNotifyObserversUnassigned();
    }

    protected void connectToTarget(OWP oWP) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(oWP != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(this.isActiveOnDocumentThread()));
        oWP.addListener(this);
        this.queueNotifyObservers(oWP.getIntegerValue());
    }

    public int getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(Se se2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(IYH.rKg(se2.rKg(), this.getTarget())));
        int n2 = ((OWP)this.getTarget()).getIntegerValue();
        this.queueNotifyObservers(n2);
    }

    private void queueNotifyObserversUnassigned() {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(this.mDefaultValue, false));
    }

    private void queueNotifyObservers(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.isInterested()));
        this.queueCallback(this, () -> this.notifyObservers(n2, true));
    }

    private void notifyObservers(int n2, boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(!bl2 ? n2 == this.mDefaultValue : true));
        if (n2 != this.mValue) {
            this.mValue = n2;
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(n2);
                }
            }
            if (bl2 && this.mUnassignedObservers != null) {
                for (Object object : this.mUnassignedObservers) {
                    ((UnassignedValueObserver)object).mCallback.valueChanged(n2);
                }
            }
        }
        if (!bl2 && this.mUnassignedObservers != null) {
            for (Object object : this.mUnassignedObservers) {
                ((UnassignedValueObserver)object).mCallback.valueChanged(((UnassignedValueObserver)object).mUnassignedValue);
            }
        }
    }
}

