/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.controller.api.DoubleValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ValueProxy;

public class DoubleValueProxy
extends ValueProxy
implements UNs,
DoubleValue {
    private double mValue;
    private final double mDefaultValue;

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject, double d3) {
        super(controlSurfaceObject);
        this.mValue = d3;
        this.mDefaultValue = d3;
    }

    public DoubleValueProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, 0.0);
    }

    @Override
    public Class getTargetType() {
        return SfO.class;
    }

    @Override
    public double get() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mValue;
    }

    public double getControlSurfaceValue() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        return this.mValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        doubleValueChangedCallback.valueChanged(this.mDefaultValue);
    }

    protected void disconnectFromTarget(SfO sfO) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(sfO != null));
        sfO.removeListener(this);
        this.queueNotifyObservers(this.mDefaultValue);
    }

    protected void connectToTarget(SfO sfO) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(sfO != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(this.isActiveOnDocumentThread()));
        sfO.addListener(this);
        this.queueNotifyObservers(sfO.getDoubleValue());
    }

    public double getDefaultValue() {
        return this.mDefaultValue;
    }

    public void eventOccurred(Se se2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(IYH.rKg(se2.rKg(), this.getTarget())));
        double d3 = ((SfO)this.getTarget()).getDoubleValue();
        this.queueNotifyObservers(d3);
    }

    private void queueNotifyObservers(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(d3));
    }

    private void notifyObservers(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        if (d3 != this.mValue) {
            this.mValue = d3;
            if (this.mObservers != null) {
                for (DoubleValueChangedCallback doubleValueChangedCallback : this.mObservers) {
                    doubleValueChangedCallback.valueChanged(d3);
                }
            }
        }
    }
}

