/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.StringValueChangedCallback;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.ComputedStringValue$1;
import com.bitwig.flt.control_surface.values.ComputedStringValue$2;
import com.bitwig.flt.control_surface.values.ComputedValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceString;
import com.bitwig.flt.control_surface.values.ControlSurfaceStringValueChangedCallback;
import com.bitwig.flt.control_surface.values.IntelligentControlSurfaceString;

public class ComputedStringValue
extends ComputedValue
implements StringValue {
    private ControlSurfaceString mValue;
    private ControlSurfaceString mDocumentValue;
    private final ControlSurfaceString mDefaultValue;

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject, ControlSurfaceString controlSurfaceString) {
        super(controlSurfaceObject);
        assert (cOY.HSF(controlSurfaceString != null));
        this.mValue = controlSurfaceString;
        this.mDocumentValue = controlSurfaceString;
        this.mDefaultValue = controlSurfaceString;
    }

    public ComputedStringValue(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, ControlSurfaceString.EMPTY);
    }

    @Override
    public String get() {
        this.checkCanGet();
        return this.mValue.get();
    }

    @Override
    public String getLimited(int n2) {
        this.atLeast(n2, 1, "maxLength");
        this.checkCanGet();
        return this.mValue.getLimited(n2);
    }

    public String getValue() {
        assert (cOY.HSF(this.isDocumentThread()));
        return this.mDocumentValue.get();
    }

    public void setValue(ControlSurfaceString controlSurfaceString) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(controlSurfaceString != null));
        if (!controlSurfaceString.equals(this.mDocumentValue)) {
            this.mDocumentValue = controlSurfaceString;
            if (this.isInterested()) {
                this.queueNotifyObservers(controlSurfaceString);
            }
        }
    }

    public final void setValue(String string) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(string != null));
        this.setValue(this.createControlSurfaceStringValue(string));
    }

    public void unassign() {
        assert (cOY.HSF(this.isDocumentThread()));
        this.setValue(this.mDefaultValue);
    }

    public void addValueObserver(StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new ComputedStringValue$1(this, stringValueChangedCallback));
    }

    public void addValueObserver(int n2, String string, StringValueChangedCallback stringValueChangedCallback) {
        this.doAddValueObserver(new ComputedStringValue$2(this, stringValueChangedCallback, string, n2));
    }

    protected void sendInitialValue(ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback) {
        controlSurfaceStringValueChangedCallback.valueChanged(this.mValue);
    }

    private void queueNotifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.queueCallback(this, () -> this.notifyObservers(controlSurfaceString));
    }

    private void notifyObservers(ControlSurfaceString controlSurfaceString) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        if (!controlSurfaceString.equals(this.mValue)) {
            this.mValue = controlSurfaceString;
            if (this.mObservers != null) {
                for (ControlSurfaceStringValueChangedCallback controlSurfaceStringValueChangedCallback : this.mObservers) {
                    controlSurfaceStringValueChangedCallback.valueChanged(controlSurfaceString);
                }
            }
        }
    }

    protected ControlSurfaceString createControlSurfaceStringValue(String string) {
        assert (cOY.HSF(this.isDocumentThread() || this.isInitializingDriver()));
        assert (cOY.HSF(string != null));
        if (string.isEmpty()) {
            return ControlSurfaceString.EMPTY;
        }
        return new IntelligentControlSurfaceString(string);
    }

    protected ControlSurfaceString getControlSurfaceString() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.mValue != null));
        return this.mValue;
    }

    static /* synthetic */ ControlSurfaceString access$000(ComputedStringValue computedStringValue) {
        return computedStringValue.mDefaultValue;
    }
}

