/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.values;

import com.bitwig.extension.callback.DoubleValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.AbstractRangedValueProxy$IntegerScaledValueObserver;
import com.bitwig.flt.control_surface.values.ComputedStringValue;
import com.bitwig.flt.control_surface.values.ControlSurfaceString;
import com.bitwig.flt.control_surface.values.RangedValueTarget;
import com.bitwig.flt.control_surface.values.ValueProxy;
import com.bitwig.flt.prefs.luh;
import com.bitwig.ramona.core.lL;
import gnu.trove.list.TDoubleList;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRangedValueProxy
extends ValueProxy
implements UNs,
SettableRangedValue {
    private double mRawValue;
    private double mNormalizedValue;
    private List mRawValueCallbacks;
    private List mIntegerScaledValueObservers;
    protected final ComputedStringValue mDisplayedValue = this.createDisplayedValue();
    private boolean mHasBeenCaught;
    private boolean mIsSettingValue;
    private double mLastSetNormalizedValue = -1.0;

    protected AbstractRangedValueProxy(ControlSurfaceObject controlSurfaceObject) {
        super(controlSurfaceObject);
    }

    @Override
    public double getRaw() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mRawValue;
    }

    @Override
    public double get() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkCanGet();
        return this.mNormalizedValue;
    }

    @Override
    public StringValue displayedValue() {
        this.newSince(2);
        return this.mDisplayedValue;
    }

    public ComputedStringValue getDisplayedValue() {
        return this.mDisplayedValue;
    }

    public void addValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        this.doAddValueObserver(doubleValueChangedCallback);
    }

    @Override
    protected boolean wantsToSendInitialDefaultValue() {
        return false;
    }

    protected void sendDefaultValue(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (cOY.HSF(false));
        assert (cOY.HSF(this.isControlSurfaceThread()));
    }

    @Override
    public void addValueObserver(int n2, IntegerValueChangedCallback integerValueChangedCallback) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        if (n2 <= 1) {
            throw new Q3u("Range must be > 1");
        }
        this.doMarkInterested();
        if (this.mIntegerScaledValueObservers == null) {
            this.mIntegerScaledValueObservers = new ArrayList(2);
        }
        this.mIntegerScaledValueObservers.add(new AbstractRangedValueProxy$IntegerScaledValueObserver(n2, integerValueChangedCallback));
    }

    @Override
    public final void set(Number number, Number number2) {
        double d3;
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (number == null || number2 == null) {
            throw new Q3u("Cannot provide null for value or resolution");
        }
        double d4 = number.doubleValue();
        if (d4 > (d3 = number2.doubleValue()) - 1.0) {
            this.getControlSurface().OkB("Value must be <= range - 1. Setting value to range - 1");
        }
        if (d4 < 0.0) {
            this.getControlSurface().OkB("Value must be >= 0. Setting value to 0");
        }
        d4 = gxQ.OkB(d4, 0.0, d3 - 1.0);
        assert (cOY.HSF(number != null));
        assert (cOY.HSF(number2 != null));
        double d5 = d3 >= 2.0 ? 1.0 / (d3 - 1.0) : 1.0;
        double d6 = d4 * d5;
        assert (cOY.HSF(d6 >= 0.0 && d6 <= 1.0));
        this.setNormalizedValue(d6, this.shouldSetImmediately());
    }

    @Override
    public final void set(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.inRange(d3, 0.0, 1.0, "value");
        this.setNormalizedValue(d3, this.shouldSetImmediately());
    }

    void markAsNotCaught() {
        assert (cOY.HSF(this.isDocumentThread()));
        this.mHasBeenCaught = false;
    }

    private boolean shouldSetImmediately() {
        yQD yQD2 = this.getControlSurface();
        if (yQD2.GNm().GNm()) {
            return !yQD2.KDn().GNm();
        }
        return false;
    }

    @Override
    public void setImmediately(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.newSince(4);
        this.inRange(d3, 0.0, 1.0, "value");
        this.setNormalizedValue(d3, true);
    }

    private void setNormalizedValue(double d3, boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(d3 >= 0.0 && d3 <= 1.0));
        this.postEvent(new AnW(this, d3, bl2, this.getTouchId()));
    }

    protected int getTouchId() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return 0;
    }

    public void doSetNormalizedValueWithTakeOver(double d3, luh luh2, TDoubleList tDoubleList) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(d3 >= 0.0 && d3 <= 1.0));
        assert (cOY.HSF(luh2 != null));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            if (this.mHasBeenCaught || luh2 == luh.rKg) {
                this.doSetNormalizedValueImmediately(d3);
            } else {
                assert (cOY.HSF(!this.mHasBeenCaught));
                assert (cOY.HSF(luh2 != luh.rKg));
                double d4 = ((RangedValueTarget)this.getTarget()).getCurrentNormalizedValue();
                boolean bl2 = false;
                if (this.mLastSetNormalizedValue != -1.0) {
                    double d5 = tDoubleList != null ? tDoubleList.get(0) : d3;
                    bl2 = AbstractRangedValueProxy.shouldBeCaughtByMovement(this.mLastSetNormalizedValue, d5, d4, luh2);
                }
                if (!bl2 && tDoubleList != null) {
                    for (int i2 = 0; !bl2 && i2 < tDoubleList.size() - 1; ++i2) {
                        double d6 = tDoubleList.get(i2);
                        double d7 = tDoubleList.get(i2 + 1);
                        bl2 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d6, d7, d4, luh2);
                    }
                    if (!bl2) {
                        double d8 = tDoubleList.get(tDoubleList.size() - 1);
                        bl2 = AbstractRangedValueProxy.shouldBeCaughtByMovement(d8, d3, d4, luh2);
                    }
                }
                if (bl2) {
                    this.doSetNormalizedValueImmediately(d3);
                }
            }
        }
    }

    private static boolean shouldBeCaughtByMovement(double d3, double d4, double d5, luh luh2) {
        assert (cOY.HSF(d3 >= 0.0 && d3 <= 1.0));
        assert (cOY.HSF(d4 >= 0.0 && d4 <= 1.0));
        assert (cOY.HSF(d5 >= 0.0 && d5 <= 1.0));
        assert (cOY.HSF(luh2 != null));
        double d6 = Math.min(d3, d4);
        double d7 = Math.max(d3, d4);
        if (d5 >= d6 && d5 <= d7) {
            return true;
        }
        return luh2 == luh.HSF ? Math.signum(d4 - d3) != Math.signum(d5 - d3) : AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d3, d5) || AbstractRangedValueProxy.isValueCloseEnoughForTakeOver(d4, d5);
    }

    private static boolean isValueCloseEnoughForTakeOver(double d3, double d4) {
        return Math.abs(d3 - d4) <= 0.05;
    }

    public void doSetNormalizedValueImmediately(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(d3 >= 0.0 && d3 <= 1.0));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            double d4 = this.normalizedValueToValue(d3);
            this.setCurrentValue(d4);
            this.mLastSetNormalizedValue = d3;
            this.mHasBeenCaught = true;
        }
    }

    @Override
    protected void targetChanged() {
        super.targetChanged();
        this.markAsNotCaught();
    }

    @Override
    public final void inc(Number number, Number number2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (number == null) {
            throw new Q3u("increment cannot be null");
        }
        if (number2 == null) {
            throw new Q3u("range cannot be null");
        }
        if (number2.doubleValue() <= 1.0) {
            throw new Q3u("range must be > 1");
        }
        double d3 = number.doubleValue() / (number2.doubleValue() - 1.0);
        this.incNormalized(d3);
    }

    @Override
    public void inc(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.inRange(d3, -1.0, 1.0, "increment");
        this.newSince(2);
        this.incNormalized(d3);
    }

    public void incNormalized(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(d3 >= -1.0 && d3 <= 1.0));
        this.postEvent(new AnW(this, d3, this.getTouchId()));
    }

    public boolean isMappable() {
        return false;
    }

    public boolean addMapping(wVK wVK2, boolean bl2, lL lL2, muD muD2) {
        assert (cOY.HSF(this.isMappable()));
        return false;
    }

    @Override
    public void addRawValueObserver(DoubleValueChangedCallback doubleValueChangedCallback) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.notNull(doubleValueChangedCallback, "callback");
        this.checkIsInitializingDriver();
        this.doMarkInterested();
        if (this.mRawValueCallbacks == null) {
            this.mRawValueCallbacks = new ArrayList(2);
        }
        this.mRawValueCallbacks.add(doubleValueChangedCallback);
    }

    @Override
    public void setRaw(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetRaw(d3));
    }

    private void doSetRaw(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(d3));
        }
    }

    @Override
    public void incRaw(double d3) {
        this.exec(() -> this.doIncRaw(d3));
    }

    private void doIncRaw(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.setCurrentValue(this.validateRawValue(this.getCurrentValue() + d3));
        }
    }

    protected double validateRawValue(double d3) {
        return d3;
    }

    public void connectToTarget(RangedValueTarget rangedValueTarget) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(rangedValueTarget != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(this.isActiveOnDocumentThread()));
        uZx uZx2 = this.getTargetValue(rangedValueTarget);
        uZx2.addListener(this);
        this.updateValueFromTarget();
        this.markAsNotCaught();
    }

    public void disconnectFromTarget(RangedValueTarget rangedValueTarget) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(rangedValueTarget != null));
        uZx uZx2 = this.getTargetValue(rangedValueTarget);
        uZx2.removeListener(this);
        this.queueNotifyObservers(0.0, 0.0);
        if (this.mDisplayedValue.isInterested()) {
            this.mDisplayedValue.unassign();
        }
        this.markAsNotCaught();
    }

    protected uZx getTargetValue(RangedValueTarget rangedValueTarget) {
        assert (cOY.HSF(this.isDocumentThread()));
        return rangedValueTarget.getValue();
    }

    public void eventOccurred(Se se2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(IYH.rKg(se2.rKg(), this.getTargetValue((RangedValueTarget)this.getTarget()))));
        this.updateValueFromTarget();
        if (!this.mIsSettingValue) {
            this.markAsNotCaught();
        }
    }

    private void updateValueFromTarget() {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        double d3 = this.getCurrentValue();
        this.queueNotifyObserversRaw(d3);
        if (this.mDisplayedValue.isInterested()) {
            ControlSurfaceString controlSurfaceString = this.createControlSurfaceString(d3);
            assert (cOY.HSF(controlSurfaceString != null));
            this.mDisplayedValue.setValue(controlSurfaceString);
        }
    }

    protected ComputedStringValue createDisplayedValue() {
        return new ComputedStringValue(this);
    }

    protected ControlSurfaceString createControlSurfaceString(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).createControlSurfaceStringForValue(d3);
    }

    protected double getCurrentValue() {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).getCurrentValue();
    }

    protected void setCurrentValue(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        assert (cOY.HSF(((RangedValueTarget)this.getTarget()).isSettable()));
        assert (cOY.HSF(!this.mIsSettingValue));
        this.beginSettingValue();
        ((RangedValueTarget)this.getTarget()).setCurrentValue(d3);
        this.endSettingValue();
    }

    protected double valueToNormalizedValue(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).valueToNormalizedValue(d3);
    }

    protected double normalizedValueToValue(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.getTarget() != null));
        return ((RangedValueTarget)this.getTarget()).normalizedValueToValue(d3);
    }

    public void doIncNormalized(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(!this.mIsSettingValue));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable()) {
            this.beginSettingValue();
            rangedValueTarget.incrementNormalized(d3);
            this.endSettingValue();
        }
    }

    private void beginSettingValue() {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(!this.mIsSettingValue));
        this.mIsSettingValue = true;
    }

    private void endSettingValue() {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.mIsSettingValue));
        assert (cOY.HSF(this.getTarget() != null));
        assert (cOY.HSF(((RangedValueTarget)this.getTarget()).isSettable()));
        this.mIsSettingValue = false;
        if (((RangedValueTarget)this.getTarget()).shouldShowPopupNotifications()) {
            this.doShowPopupNotification();
        }
    }

    public void showPopupNotification() {
        assert (cOY.HSF(this.isDocumentThread()));
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        if (rangedValueTarget != null && rangedValueTarget.isSettable() && rangedValueTarget.shouldShowPopupNotifications()) {
            this.doShowPopupNotification();
        }
    }

    private void doShowPopupNotification() {
        RangedValueTarget rangedValueTarget = (RangedValueTarget)this.getTarget();
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(rangedValueTarget != null));
        assert (cOY.HSF(rangedValueTarget.isSettable()));
        assert (cOY.HSF(rangedValueTarget.shouldShowPopupNotifications()));
        String string = rangedValueTarget.getPopupNotificationName();
        String string2 = rangedValueTarget.getPopupNotificationValueText();
        this.getControlSurface().rKg(string2, string);
    }

    private final void queueNotifyObserversRaw(double d3) {
        double d4 = this.valueToNormalizedValue(d3);
        this.queueNotifyObservers(d3, d4);
    }

    private void queueNotifyObservers(double d3, double d4) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(d4 >= 0.0 && d4 <= 1.0));
        this.queueCallback(this, () -> this.notifyObservers(d3, d4));
    }

    private void notifyObservers(double d3, double d4) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInterested()));
        assert (cOY.HSF(d4 >= 0.0 && d4 <= 1.0));
        double d5 = this.mRawValue;
        double d6 = this.mNormalizedValue;
        this.mRawValue = d3;
        this.mNormalizedValue = d4;
        if (d4 != d6) {
            if (this.mObservers != null) {
                for (Object object : this.mObservers) {
                    object.valueChanged(d4);
                }
            }
            if (this.mIntegerScaledValueObservers != null) {
                for (Object object : this.mIntegerScaledValueObservers) {
                    IntegerValueChangedCallback integerValueChangedCallback = AbstractRangedValueProxy$IntegerScaledValueObserver.access$000((AbstractRangedValueProxy$IntegerScaledValueObserver)object);
                    int n2 = AbstractRangedValueProxy$IntegerScaledValueObserver.access$100((AbstractRangedValueProxy$IntegerScaledValueObserver)object);
                    int n3 = gxQ.rKg(Math.round((float)d4 * (float)n2 - 0.5f), 0, n2 - 1);
                    integerValueChangedCallback.valueChanged(n3);
                }
            }
        }
        if (d3 != d5 && this.mRawValueCallbacks != null) {
            for (Object object : this.mRawValueCallbacks) {
                object.valueChanged(d3);
            }
        }
    }

    public void doTouch(boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
    }
}

