/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Parameter;
import com.bitwig.extension.controller.api.UserControlBank;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.RemappableParameterProxy;

public class UserControlBankObject
extends ControlSurfaceObject
implements UserControlBank {
    private RemappableParameterProxy[] mControllers;

    public UserControlBankObject(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.setKey("UserControl");
        if (n2 < 1) {
            throw new Q3u("Size of user controls must be >= 1");
        }
        this.mControllers = new RemappableParameterProxy[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Control" + i2;
            RemappableParameterProxy remappableParameterProxy = new RemappableParameterProxy((ControlSurfaceObject)this, string);
            remappableParameterProxy.setIndexInGroup(i2);
            this.addChild(remappableParameterProxy);
            this.mControllers[i2] = remappableParameterProxy;
        }
    }

    @Override
    public Parameter getControl(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return (Parameter)this.returnArrayItem(this.mControllers, n2);
    }
}

