/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.Setting;
import com.bitwig.extension.controller.api.Settings;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.values.EnumSetting;
import com.bitwig.flt.control_surface.values.NumberSetting;
import com.bitwig.flt.control_surface.values.SignalSetting;
import com.bitwig.flt.control_surface.values.StringSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SettingsProxy
extends ControlSurfaceDocumentProxy
implements Settings {
    protected Map mSettings = new HashMap(32);
    protected List mCategories = new ArrayList(4);

    public SettingsProxy(ControlSurfaceObject controlSurfaceObject, String string) {
        super(controlSurfaceObject);
        this.setKey(string);
    }

    private void addSetting(Setting setting) {
        List<Setting> list;
        assert (cOY.HSF(setting != null));
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkCanAddSetting(setting.getLabel(), setting.getCategory());
        this.addChild((ControlSurfaceObject)((Object)setting));
        String string = setting.getCategory();
        if (!this.mCategories.contains(string)) {
            this.mCategories.add(string);
        }
        if (this.mSettings.containsKey(string)) {
            list = (List)this.mSettings.get(string);
        } else {
            list = new ArrayList(32);
            this.mSettings.put(string, list);
        }
        list.add(setting);
    }

    protected final int getSettingIndex(Setting setting) {
        return this.getSettings(setting.getCategory()).indexOf(setting);
    }

    public List getSettings(String string) {
        return (List)this.mSettings.get(string);
    }

    private void checkCanAddSetting(String string, String string2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (string == null || string.isEmpty()) {
            throw new Q3u("Label must be provided for a setting");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new Q3u("Category must be provided for a setting");
        }
        if (!this.getControlSurface().CqD()) {
            throw new Q3u("Settings can only be added during script initialization");
        }
        List list = (List)this.mSettings.get(string2);
        if (list != null && list.contains(string)) {
            throw new Q3u("A setting with name " + string + " in category " + string2 + " has already been added");
        }
    }

    @Override
    public SignalSetting getSignalSetting(String string, String string2, String string3) {
        SignalSetting signalSetting = new SignalSetting(this, string, string2, string3);
        this.addSetting(signalSetting);
        return signalSetting;
    }

    @Override
    public NumberSetting getNumberSetting(String string, String string2, double d3, double d4, double d5, String string3, double d6) {
        NumberSetting numberSetting = new NumberSetting(this, string, string2, d3, d4, d5, string3, d6);
        this.addSetting(numberSetting);
        return numberSetting;
    }

    @Override
    public EnumSetting getEnumSetting(String string, String string2, String[] stringArray, String string3) {
        EnumSetting enumSetting = new EnumSetting(this, string, string2, stringArray, string3);
        this.addSetting(enumSetting);
        return enumSetting;
    }

    @Override
    public StringSetting getStringSetting(String string, String string2, int n2, String string3) {
        StringSetting stringSetting = new StringSetting(this, string, string2, string3);
        this.addSetting(stringSetting);
        return stringSetting;
    }
}

