/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IndexedStringValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.Scene;
import com.bitwig.extension.controller.api.SceneBank;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CurrentDocumentListener;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.SceneBankProxy$1;
import com.bitwig.flt.control_surface.proxy.SceneProxy;
import com.bitwig.flt.document.core.iface.UZ3;

public class SceneBankProxy
extends ControlSurfaceDocumentObjectProxy
implements SceneBank,
CurrentDocumentListener {
    private int mNumScenes;
    private final ListValueBankItemTargetUpdater mBankUpdater;
    private final SceneProxy[] mSceneProxies;

    protected SceneBankProxy(ControlSurfaceObject controlSurfaceObject, int n2) {
        super(controlSurfaceObject);
        this.setKey("Scene Bank");
        if (n2 < 1) {
            throw new Q3u("At least 1 scene is required.");
        }
        this.mNumScenes = n2;
        this.mSceneProxies = new SceneProxy[this.mNumScenes];
        for (int i2 = 0; i2 < this.mNumScenes; ++i2) {
            this.mSceneProxies[i2] = new SceneProxy((ControlSurfaceObject)this, this.getKey() + " / Scene " + i2);
        }
        this.mBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mSceneProxies);
    }

    @Override
    public int getSizeOfBank() {
        return this.mNumScenes;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public Scene getItemAt(int n2) {
        return (Scene)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public Class getTargetType() {
        return jcl.class;
    }

    protected UZ3 getDocumentFromTarget(jcl jcl2) {
        return (UZ3)jcl2.jWS(UZ3.class);
    }

    @Override
    public void launchScene(int n2) {
        if (n2 >= 0 && n2 < this.mNumScenes) {
            this.mSceneProxies[n2].launch();
        }
    }

    @Override
    public void scrollPageUp() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageBackwards() {
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageForwards() {
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollPageDown() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollBackwards() {
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollUp() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollForwards() {
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.deprecated(1, 4);
        this.mBankUpdater.scrollTo(n2);
    }

    @Override
    public void scrollBy(int n2) {
        this.mBankUpdater.scrollBy(n2);
    }

    @Override
    public void scrollByPages(int n2) {
        this.mBankUpdater.scrollByPages(n2);
    }

    @Override
    public Scene getScene(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return (Scene)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public void setCurrentDocument(UZ3 uZ3) {
        if (uZ3 != this.getDocument()) {
            if (uZ3 != null) {
                this.setTarget(uZ3.pv().wxK());
            } else {
                this.setTarget(null);
            }
        }
    }

    protected void connectToTarget(jcl jcl2) {
        assert (cOY.jWS(jcl2 != null));
        this.mBankUpdater.setTarget(jcl2.rKg());
    }

    protected void disconnectFromTarget(jcl jcl2) {
        this.mBankUpdater.clearTarget();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        this.newSince(2);
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        this.newSince(2);
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addSceneCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use sceneCount() instead");
        this.mBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addNameObserver(IndexedStringValueChangedCallback indexedStringValueChangedCallback) {
        for (int i2 = 0; i2 < this.mSceneProxies.length; ++i2) {
            int n2 = i2;
            this.mSceneProxies[i2].name().addValueObserver(new SceneBankProxy$1(this, indexedStringValueChangedCallback, n2));
        }
    }

    @Override
    public void returnToArrangement() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doReturnToArrangement());
    }

    private void doReturnToArrangement() {
        assert (cOY.HSF(this.isDocumentThread()));
        jcl jcl2 = (jcl)this.getTarget();
        if (jcl2 != null) {
            jcl2.aXU();
        }
    }

    @Override
    public void launch(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (this.validSceneIndex(n2)) {
            this.mSceneProxies[n2].launch();
        }
    }

    private boolean validSceneIndex(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (n2 >= 0 && n2 < this.mSceneProxies.length) {
            return true;
        }
        if (this.getRequiredApiVersion() == 1) {
            return false;
        }
        throw new Q3u("Invalid scene index: " + n2);
    }

    @Override
    public void stop() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doStop());
    }

    private void doStop() {
        jcl jcl2 = (jcl)this.getTarget();
        if (jcl2 != null) {
            jcl2.jWS();
        }
    }

    public ListValueBankItemTargetUpdater getBankUpdater() {
        return this.mBankUpdater;
    }
}

