/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.DrumPadBank;
import com.bitwig.flt.control_surface.proxy.ChannelBankProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.proxy.DrumPadProxy;
import com.bitwig.flt.document.core.iface.UZ3;
import java.util.ArrayList;
import java.util.List;

public class DrumPadBankProxy
extends ChannelBankProxy
implements DrumPadBank {
    private boolean mIsIndicating = true;
    private final int mNumLanes;
    private final List mPads;

    public DrumPadBankProxy(ControlSurfaceObject controlSurfaceObject, int n2, int n3) {
        super(controlSurfaceObject, "DrumPadBank-" + n2, n2, n3);
        if (n2 < 1) {
            throw new Q3u("At least 1 track is required.");
        }
        this.mNumLanes = n2;
        this.mPads = new ArrayList(n2);
        this.mChannelScrollStepSize = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getKey() + "/Pad" + i2;
            DrumPadProxy drumPadProxy = new DrumPadProxy(this, string, i2, n3, this.mIsIndicating);
            this.mPads.add(drumPadProxy);
            this.addChild(drumPadProxy);
        }
        this.initChannelProxies();
    }

    @Override
    public Class getTargetType() {
        return iGk.class;
    }

    protected UZ3 getDocumentFromTarget(iGk iGk2) {
        return iGk2.NJt();
    }

    @Override
    public void setIndication(boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetIndication(bl2));
    }

    private void doSetIndication(boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        for (ControlSurfaceProxy controlSurfaceProxy : this.mChannels) {
            DrumPadProxy drumPadProxy = (DrumPadProxy)controlSurfaceProxy;
            drumPadProxy.setIndicating(bl2);
        }
    }

    @Override
    protected int getScrollPositionThatPageShouldAlignTo() {
        return 36;
    }

    @Override
    protected DrumPadProxy createChannelProxy(int n2, int n3, String string) {
        return new DrumPadProxy(this, string + n3, n3, n2, this.mIsIndicating);
    }

    protected Ipa getChannelsListValueFromTarget(iGk iGk2) {
        return iGk2.OkB();
    }

    protected void connectToTarget(iGk iGk2) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (px px2 : iGk2.fR_()) {
            int n4 = px2.lBt().jWS();
            n2 = Math.min(n4, n2);
            n3 = Math.max(n4, n3);
        }
        int n5 = this.mChannelBankUpdater.getScrollPositionValue();
        if (n3 >= 0 && (n5 < n2 || n5 > n3)) {
            int n6 = n2 / 4;
            this.mChannelBankUpdater.doScrollTo(4 * n6);
        } else {
            this.mChannelBankUpdater.doScrollTo(36);
        }
    }

    protected void disconnectFromTarget(iGk iGk2) {
    }
}

