/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Device;
import com.bitwig.extension.controller.api.DeviceBank;
import com.bitwig.extension.controller.api.DeviceChain;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy$1;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy$2;
import com.bitwig.flt.control_surface.proxy.DeviceBankProxy$3;
import com.bitwig.flt.control_surface.proxy.DeviceChainProxy;
import com.bitwig.flt.control_surface.proxy.DeviceProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.document.core.iface.UZ3;

public class DeviceBankProxy
extends ControlSurfaceDocumentObjectProxy
implements DeviceBank {
    private final int mNumDevices;
    private final DeviceProxy[] mDeviceProxies;
    private final ListValueBankItemTargetUpdater mDeviceBankUpdater;
    private DeviceChain mDeviceChainSection;

    protected DeviceBankProxy(DeviceChainProxy deviceChainProxy, int n2, int n3) {
        super(deviceChainProxy);
        this.setKey("Device Chain");
        if (n2 < 1) {
            throw new Q3u("At least 1 device is required.");
        }
        this.mDeviceChainSection = deviceChainProxy;
        this.mNumDevices = n2;
        this.mDeviceProxies = new DeviceProxy[n2];
        for (int i2 = 0; i2 < this.mNumDevices; ++i2) {
            this.mDeviceProxies[i2] = new DeviceProxy(this, this.getKey() + " / Device " + i2, n3, deviceChainProxy);
        }
        this.mDeviceBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mDeviceProxies);
    }

    @Override
    public Class getTargetType() {
        return icD.class;
    }

    protected UZ3 getDocumentFromTarget(icD icD2) {
        return icD2.NJt();
    }

    @Override
    public DeviceChain getDeviceChain() {
        return this.mDeviceChainSection;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mDeviceBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mDeviceBankUpdater.getCursorIndex();
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mDeviceBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mDeviceBankUpdater.getCanScrollForwards();
    }

    @Override
    public int getSizeOfBank() {
        return this.mNumDevices;
    }

    @Override
    public Device getItemAt(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mDeviceBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollBy(int n2) {
        this.mDeviceBankUpdater.scrollBy(n2);
    }

    @Override
    public void scrollByPages(int n2) {
        this.mDeviceBankUpdater.scrollByPages(n2);
    }

    public void navigateToDeviceLayer(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0) {
            throw new Q3u("layerIndex must be >= 0");
        }
        this.exec(new DeviceBankProxy$1(this, n2, n3));
    }

    public void navigateToKeyPad(int n2, int n3) {
        this.validIndex(this.mDeviceProxies, n2);
        if (n3 < 0 || n3 > 127) {
            throw new Q3u("Invalid key");
        }
        this.exec(new DeviceBankProxy$2(this, n2, n3));
    }

    public void navigateToDeviceSlot(int n2, String string) {
        this.validIndex(this.mDeviceProxies, n2);
        this.notNull(string, "chain");
        this.exec(new DeviceBankProxy$3(this, n2, string));
    }

    @Override
    public void scrollPageUp() {
        this.mDeviceBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mDeviceBankUpdater.scrollByPages(1);
    }

    @Override
    public void scrollUp() {
        this.mDeviceBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mDeviceBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollTo(int n2) {
        this.mDeviceBankUpdater.getScrollPosition().set(n2);
    }

    @Override
    public Device getDevice(int n2) {
        return (Device)((Object)this.mDeviceBankUpdater.getItemAt(n2));
    }

    protected void connectToTarget(icD icD2) {
        assert (cOY.jWS(icD2 != null));
        this.mDeviceBankUpdater.setTarget(icD2.lpO());
        this.connectObservers(icD2);
    }

    protected void disconnectFromTarget(icD icD2) {
        this.mDeviceBankUpdater.clearTarget();
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback, int n2) {
        this.deprecated(1, 2, "Use scrollPosition() instead");
        this.mDeviceBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback, n2);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollBackwards() instead");
        this.mDeviceBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollForwards() instead");
        this.mDeviceBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addDeviceCountObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use itemCount().addValueObserver(callback)");
        this.mDeviceBankUpdater.getListItemCount().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void browseToInsertDevice(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.inRange(n2, 0, this.getSizeOfBank(), "index");
        this.exec(() -> this.doBrowseToInsertDevice(n2));
    }

    private void doBrowseToInsertDevice(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(n2 >= 0 && n2 <= this.getSizeOfBank()));
        icD icD2 = (icD)this.getTarget();
        if (icD2 != null) {
            int n3 = gxQ.rKg(this.mDeviceBankUpdater.getScrollPositionValue() + n2, 0, icD2.u1q());
            if (n3 > 0) {
                ITw iTw = icD2.OkB(n3 - 1);
                aSW.rKg(null, new aSC(iTw));
            } else {
                aSW.rKg(null, new aSJ(icD2));
            }
        }
    }

    static /* synthetic */ DeviceProxy[] access$000(DeviceBankProxy deviceBankProxy) {
        return deviceBankProxy.mDeviceProxies;
    }
}

