/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.StringArrayValue;
import com.bitwig.extension.controller.api.StringValue;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$1;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$2;
import com.bitwig.flt.control_surface.proxy.CursorRemoteControlsPageProxy$SelectedPageIndexValue;
import com.bitwig.flt.control_surface.proxy.RemoteControlProxy;
import com.bitwig.flt.control_surface.proxy.RemoteControlsPageProxy;
import com.bitwig.flt.control_surface.values.BooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableIntegerValueProxy;
import com.bitwig.flt.control_surface.values.StringArrayValueProxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class CursorRemoteControlsPageProxy
extends ControlSurfaceDocumentObjectProxy
implements CursorRemoteControlsPage {
    private static final String[] NO_PAGE_NAMES = new String[0];
    private final nDR mPagesChangedListener = new CursorRemoteControlsPageProxy$1(this);
    private boolean mHasScheduledUpdateToPages;
    private List mPages;
    private final StringArrayValueProxy mPageNamesValue;
    private final SettableIntegerValueProxy mSelectedPageIndexValue;
    private final Lr mPageNames;
    private final RemoteControlsPageProxy mSelectedPageProxy;
    private uRp mHasPrevParameterPage = new uRp(false);
    private uRp mHasNextParameterPage = new uRp(false);
    private final CursorRemoteControlsPageProxy$SelectedPageIndexValue mSelectedPageIndex = new CursorRemoteControlsPageProxy$SelectedPageIndexValue(this, 0);
    private final BooleanValueProxy mHasNextPageValue;
    private final BooleanValueProxy mHasPreviousPageValue;
    private Gpa mPageSelector;
    private boolean mIsChangingPageFromController;
    private final UNs mSelectedPageListener = new CursorRemoteControlsPageProxy$2(this);
    private boolean mHasScheduledUpdateSelectedPage;

    protected CursorRemoteControlsPageProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2) {
        super(controlSurfaceObject);
        assert (cOY.HSF(string != null));
        assert (cOY.HSF(n2 >= 1));
        this.mSelectedPageProxy = new RemoteControlsPageProxy(this, string, n2);
        this.mPageNamesValue = new StringArrayValueProxy((ControlSurfaceObject)this, NO_PAGE_NAMES);
        this.mPageNames = new Lr(NO_PAGE_NAMES);
        this.mSelectedPageIndexValue = new SettableIntegerValueProxy((ControlSurfaceObject)this, -1);
        this.mHasNextPageValue = new BooleanValueProxy(this);
        this.mHasPreviousPageValue = new BooleanValueProxy(this);
    }

    @Override
    public int getParameterCount() {
        return this.mSelectedPageProxy.getParameterCount();
    }

    @Override
    public RemoteControlProxy getParameter(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return this.mSelectedPageProxy.getParameter(n2);
    }

    public RemoteControlsPageProxy getSelectedPage() {
        return this.mSelectedPageProxy;
    }

    @Override
    public StringValue getName() {
        this.newSince(4);
        return this.mSelectedPageProxy.getName();
    }

    @Override
    public SettableIntegerValue selectedPageIndex() {
        return this.mSelectedPageIndexValue;
    }

    private void doSelectPageAtIndex(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mPageSelector != null && n2 >= 0) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.rKg(n2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPreviousPage(boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectPreviousPage(bl2));
    }

    private void doSelectPreviousPage(boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.OkB(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectFirst() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(this::doSelectFirst);
    }

    private void doSelectFirst() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.OkB();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectLast() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(this::doSelectLast);
    }

    private void doSelectLast() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.HSF();
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNext() {
        this.selectNextPage(false);
    }

    @Override
    public void selectNextPage(boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doSelectNextPage(bl2));
    }

    private void doSelectNextPage(boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.rKg(bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectNextPageMatching(String string, boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (string == null) {
            throw new Q3u("expression cannot be null");
        }
        this.exec(() -> this.doSelectNextPageMatching(string, bl2));
    }

    private void doSelectNextPageMatching(String string, boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.rKg(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void selectPrevious() {
        this.selectPreviousPage(false);
    }

    @Override
    public void selectPreviousPageMatching(String string, boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (string == null) {
            throw new Q3u("expression cannot be null");
        }
        this.exec(() -> this.doSelectPreviousPageMatching(string, bl2));
    }

    private void doSelectPreviousPageMatching(String string, boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(string != null));
        if (this.mPageSelector != null) {
            this.mIsChangingPageFromController = true;
            this.mPageSelector.OkB(string, bl2);
            this.mIsChangingPageFromController = false;
        }
    }

    @Override
    public void addCanSelectNextObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasNextPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanSelectPreviousObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use hasNext() instead");
        this.mHasPreviousPageValue.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue hasPrevious() {
        return this.mHasPreviousPageValue;
    }

    @Override
    public BooleanValue hasNext() {
        return this.mHasNextPageValue;
    }

    protected abstract Gpa getPageSelectorForRemoteControls(iLo var1);

    protected void connectToTarget(iLo iLo2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(iLo2 != null));
        assert (cOY.HSF(this.mPageSelector == null));
        this.mPageSelector = this.getPageSelectorForRemoteControls(iLo2);
        this.updatePages();
        this.mPageNamesValue.setTarget(this.mPageNames);
        iLo2.rKg(this.mPagesChangedListener);
        this.mPageSelector.rKg(this.mSelectedPageListener);
        this.mSelectedPageIndexValue.setTarget(this.mSelectedPageIndex);
        this.mHasNextPageValue.setTarget(this.mHasNextParameterPage);
        this.mHasPreviousPageValue.setTarget(this.mHasPrevParameterPage);
        this.updateSelectedPage();
    }

    protected void disconnectFromTarget(iLo iLo2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(iLo2 != null));
        assert (cOY.HSF(this.mPageSelector != null));
        this.mSelectedPageIndexValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mHasNextPageValue.clearTarget();
        this.mPageNamesValue.clearTarget();
        this.mPageSelector.OkB(this.mSelectedPageListener);
        iLo2.OkB(this.mPagesChangedListener);
        this.mPageSelector = null;
        this.mSelectedPageProxy.clearTarget();
    }

    private void invalidatePages() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateToPages) {
            this.mHasScheduledUpdateToPages = true;
            this.runAtEndOfEvent(this::updatePages);
        }
    }

    @Override
    public StringArrayValue pageNames() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return this.mPageNamesValue;
    }

    protected void ensurePagesUpdated() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mHasScheduledUpdateToPages) {
            this.updatePages();
        }
    }

    private void updatePages() {
        assert (cOY.HSF(this.isDocumentThread()));
        this.mHasScheduledUpdateToPages = false;
        this.setPages(this.calculatePages());
    }

    private void setPages(List list) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(list != null));
        if (!IYH.rKg(this.mPages, list)) {
            this.mPages = list;
            this.pagesChanged();
        }
        this.updatePageNames();
    }

    protected void pagesChanged() {
        assert (cOY.HSF(this.isDocumentThread()));
        this.updateHasNextAndPrevPage();
    }

    private void updateHasNextAndPrevPage() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mHasScheduledUpdateSelectedPage) {
            this.updateSelectedPage();
        }
        if (this.getTarget() != null) {
            int n2 = this.getPageCount();
            int n3 = this.mSelectedPageIndex.getValue();
            assert (cOY.HSF(n3 == this.clampPageToRange(n3)));
            this.mHasPrevParameterPage.rKg(n3 > 0);
            this.mHasNextParameterPage.rKg(n3 < n2 - 1);
        } else {
            this.mHasPrevParameterPage.rKg(false);
            this.mHasNextParameterPage.rKg(false);
        }
    }

    private void scheduleUpdateSelectedPage() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (!this.mHasScheduledUpdateSelectedPage) {
            this.mHasScheduledUpdateSelectedPage = true;
            this.runAtEndOfEvent(this::updateSelectedPage);
        }
    }

    private void updateSelectedPage() {
        assert (cOY.HSF(this.isDocumentThread()));
        this.ensurePagesUpdated();
        this.mHasScheduledUpdateSelectedPage = false;
        WrQ wrQ = this.mPageSelector != null ? this.mPageSelector.jWS() : null;
        this.mSelectedPageProxy.setTarget(wrQ);
        if (wrQ != null) {
            int n2 = this.getPageIndex(wrQ);
            assert (cOY.HSF(n2 >= 0));
            this.mSelectedPageIndex.doSetValue(n2);
            if (this.mIsChangingPageFromController) {
                this.showMappingNotification((String)wrQ.gC_().getValue());
            }
        } else {
            this.mSelectedPageIndex.doSetValue(0);
        }
        this.updateHasNextAndPrevPage();
    }

    protected int clampPageToRange(int n2) {
        int n3 = this.getPageCount();
        return n3 > 0 ? gxQ.rKg(n2, 0, n3 - 1) : 0;
    }

    private List calculatePages() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (this.mPageSelector == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mPageSelector.rKg();
    }

    private void updatePageNames() {
        this.setPageNames(this.calculatePageNames());
    }

    private String[] calculatePageNames() {
        int n2 = this.getPageCount();
        if (n2 == 0) {
            return NO_PAGE_NAMES;
        }
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)this.getPageAt(i2).gC_().getValue();
        }
        return stringArray;
    }

    private void setPageNames(String[] stringArray) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(stringArray != null));
        Object[] objectArray = (String[])this.mPageNames.getValue();
        assert (cOY.HSF(objectArray != null));
        if (!Arrays.equals(stringArray, objectArray)) {
            this.mPageNames.setValue(stringArray);
        }
    }

    public int getPageCount() {
        assert (cOY.HSF(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (cOY.HSF(!this.mHasScheduledUpdateToPages));
        return this.mPages != null ? this.mPages.size() : 0;
    }

    public WrQ getPageAt(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.ensurePagesUpdated();
        assert (cOY.HSF(!this.mHasScheduledUpdateToPages));
        return (WrQ)this.mPages.get(n2);
    }

    public int getPageIndex(WrQ wrQ) {
        assert (cOY.HSF(wrQ != null));
        assert (cOY.HSF(this.isDocumentThread()));
        this.ensurePagesUpdated();
        return this.mPages.indexOf(wrQ);
    }

    protected void showMappingNotification(String string) {
        if (this.getHost().getNotificationSettings().shouldShowMappingNotifications()) {
            this.getControlSurface().rKg(string, "Mapping");
        }
    }

    static /* synthetic */ void access$000(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy) {
        cursorRemoteControlsPageProxy.invalidatePages();
    }

    static /* synthetic */ void access$100(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy, int n2) {
        cursorRemoteControlsPageProxy.doSelectPageAtIndex(n2);
    }

    static /* synthetic */ void access$300(CursorRemoteControlsPageProxy cursorRemoteControlsPageProxy) {
        cursorRemoteControlsPageProxy.scheduleUpdateSelectedPage();
    }
}

