/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.ObjectProxy;
import com.bitwig.extension.controller.api.Subscribable;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.DelegatingControlSurfaceObjectProxy;

public abstract class ControlSurfaceProxy
extends ControlSurfaceObject
implements Subscribable {
    private Object mTarget;
    private boolean mIsSubscribed;
    private boolean mIsSubscribedOnDocumentThread;

    protected ControlSurfaceProxy(ControlSurfaceObject controlSurfaceObject, boolean bl2) {
        super(controlSurfaceObject);
        this.mIsSubscribed = bl2;
        this.mIsSubscribedOnDocumentThread = bl2;
    }

    protected ControlSurfaceProxy(ControlSurfaceObject controlSurfaceObject) {
        this(controlSurfaceObject, true);
    }

    public Object getTargetOfType(Class clazz) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(clazz != null));
        if (clazz.isAssignableFrom(this.getTargetType())) {
            return this.getTarget();
        }
        return null;
    }

    public final Object getDeepestTarget() {
        ControlSurfaceProxy controlSurfaceProxy = this.getDeepestProxy();
        assert (cOY.HSF(controlSurfaceProxy != null));
        assert (cOY.HSF(!(controlSurfaceProxy instanceof DelegatingControlSurfaceObjectProxy)));
        return controlSurfaceProxy.getTarget();
    }

    public ControlSurfaceProxy getDeepestProxy() {
        return this;
    }

    @Override
    public final void subscribe() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.setIsSubscribed(true);
    }

    @Override
    public final void unsubscribe() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.setIsSubscribed(false);
    }

    public abstract Class getTargetType();

    public final Object getTarget() {
        assert (cOY.HSF(this.isDocumentThread()));
        return this.mTarget;
    }

    public void setTarget(Object object) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.isTargetValid(object)));
        if (!IYH.rKg(object, this.mTarget)) {
            if (this.mTarget != null && this.mIsSubscribedOnDocumentThread && this.isInterested()) {
                this.disconnectFromTarget(this.mTarget);
            }
            this.mTarget = object;
            this.targetChanged();
            if (this.mTarget != null && this.mIsSubscribedOnDocumentThread && this.isInterested()) {
                this.connectToTarget(this.mTarget);
            }
        }
    }

    public final void clearTarget() {
        this.setTarget(null);
    }

    protected boolean isTargetValid(Object object) {
        return this.isDocumentThread();
    }

    protected void targetChanged() {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.isTargetValid(this.mTarget)));
        this.getHost().targetChanged(this, this.mTarget);
    }

    public final BooleanValue createEqualsValue(ObjectProxy objectProxy) {
        return this.getHost().createAreProxiesEqualValue(this, (ControlSurfaceProxy)((Object)objectProxy));
    }

    @Override
    public final boolean isSubscribed() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return this.mIsSubscribed;
    }

    @Override
    public final void setIsSubscribed(boolean bl2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (bl2 != this.mIsSubscribed) {
            this.mIsSubscribed = bl2;
            this.exec(() -> this.doSetIsSubscribed(bl2));
        }
        assert (cOY.HSF(this.mIsSubscribed == bl2));
    }

    private void doSetIsSubscribed(boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        if (bl2 != this.mIsSubscribedOnDocumentThread) {
            this.mIsSubscribedOnDocumentThread = bl2;
            if (this.mTarget != null && this.isInterested()) {
                if (bl2) {
                    this.connectToTarget(this.mTarget);
                } else {
                    this.disconnectFromTarget(this.mTarget);
                }
            }
        }
    }

    public final boolean isActiveOnDocumentThread() {
        assert (cOY.HSF(this.isDocumentThread()));
        return this.mIsSubscribedOnDocumentThread;
    }

    protected abstract void connectToTarget(Object var1);

    protected abstract void disconnectFromTarget(Object var1);

    protected boolean isInterested() {
        return true;
    }
}

