/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.ColorValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.callback.StepDataChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableBeatTimeValue;
import com.bitwig.extension.controller.api.SettableColorValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.flt.app.cj;
import com.bitwig.flt.control_surface.proxy.ClipLauncherSlotBankProxy;
import com.bitwig.flt.control_surface.proxy.ClipProxy$1;
import com.bitwig.flt.control_surface.proxy.ClipProxy$2;
import com.bitwig.flt.control_surface.proxy.ClipProxy$3;
import com.bitwig.flt.control_surface.proxy.ClipProxy$4;
import com.bitwig.flt.control_surface.proxy.ClipProxy$5;
import com.bitwig.flt.control_surface.proxy.ClipProxy$Step;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceDocumentObjectProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;
import com.bitwig.flt.control_surface.proxy.NoteLaneProxy;
import com.bitwig.flt.control_surface.proxy.TrackProxy;
import com.bitwig.flt.control_surface.values.AbsBeatTimeProxy;
import com.bitwig.flt.control_surface.values.BeatTimeProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.flt.control_surface.values.RangedValueProxy;
import com.bitwig.flt.control_surface.values.RelativeBeatTimeProxy;
import com.bitwig.flt.control_surface.values.SettableBooleanValueProxy;
import com.bitwig.flt.control_surface.values.SettableColorValueProxy;
import com.bitwig.flt.document.core.iface.UZ3;
import com.bitwig.ramona.core.QwT;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ClipProxy
extends ControlSurfaceDocumentObjectProxy
implements Clip {
    private nDR mPlaybackPositionListener = new ClipProxy$3(this);
    private QwT mHierarchyListener = new ClipProxy$4(this);
    private CDB mSelectionChangeListener = new ClipProxy$5(this);
    private AMz mStepGrid;
    private final int mGridHeight;
    private final int mGridWidth;
    private List mSteps;
    private int mBaseKey;
    private int mBaseStep;
    private int mLastPlaybackStep = -1;
    private double mStepSize = 0.25;
    private final ComputedBooleanValue mCanScrollKeysUp;
    private final ComputedBooleanValue mCanScrollKeysDown;
    private final ComputedBooleanValue mCanScrollStepsBackwards;
    private final ComputedBooleanValue mCanScrollStepsForwards;
    private NoteLaneProxy[] mNoteLanes;
    private final ListValueBankItemTargetUpdater mNoteLanesBankUpdater;
    private SettableBooleanValueProxy mShuffle;
    private RangedValueProxy mAccent;
    private SettableBooleanValueProxy mIsLoopEnabled;
    private BeatTimeProxy mPlayStart;
    private BeatTimeProxy mPlayStop;
    private BeatTimeProxy mLoopStart;
    private BeatTimeProxy mLoopLength;
    private boolean mHasInvalidatedGrid = false;
    private Timer mUpdateStepGridTimer;
    private final TrackProxy mTrackSection;
    private final SettableColorValueProxy mColor;
    private final ComputedIntegerValue mPlayingStep;
    private final List mStepDataChangedCallbacks = new ArrayList(2);

    public ClipProxy(ControlSurfaceObject controlSurfaceObject, String string, int n2, int n3) {
        super(controlSurfaceObject);
        int n4;
        this.setKey(string);
        this.mGridHeight = n3;
        this.mGridWidth = n2;
        this.mBaseKey = 0;
        this.mStepGrid = new wDp(this.mStepSize);
        this.mSteps = new ArrayList(this.mGridHeight * this.mGridWidth);
        for (n4 = 0; n4 < n3; ++n4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mSteps.add(new ClipProxy$Step(this, i2, n4));
            }
        }
        if (this.mGridHeight > 0) {
            this.mNoteLanes = new NoteLaneProxy[this.mGridHeight];
            for (n4 = 0; n4 < this.mGridHeight; ++n4) {
                NoteLaneProxy noteLaneProxy;
                String string2 = string + "/NoteLane" + n4;
                this.mNoteLanes[n4] = noteLaneProxy = new NoteLaneProxy(this, string2, n4);
                this.addChild(noteLaneProxy);
            }
            this.mNoteLanesBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mNoteLanes);
        } else {
            this.mNoteLanes = null;
            this.mNoteLanesBankUpdater = null;
        }
        this.mShuffle = new SettableBooleanValueProxy(this);
        this.mAccent = new RangedValueProxy(this);
        this.mIsLoopEnabled = new SettableBooleanValueProxy(this);
        this.mPlayStart = new AbsBeatTimeProxy(this);
        this.mPlayStop = new AbsBeatTimeProxy(this);
        this.mLoopStart = new AbsBeatTimeProxy(this);
        this.mLoopLength = new RelativeBeatTimeProxy(this);
        this.mColor = new SettableColorValueProxy(this);
        this.mTrackSection = new TrackProxy(this, "ClipParentTrack", -1, 0, 1);
        this.mCanScrollKeysDown = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollKeysUp = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsBackwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mCanScrollStepsForwards = new ComputedBooleanValue((ControlSurfaceObject)this, false);
        this.mPlayingStep = new ComputedIntegerValue((ControlSurfaceObject)this, -1);
    }

    @Override
    public Class getTargetType() {
        return bwe.class;
    }

    protected UZ3 getDocumentFromTarget(bwe bwe2) {
        return bwe2.M1o();
    }

    @Override
    public BooleanValue canScrollKeysUp() {
        this.newSince(2);
        return this.mCanScrollKeysUp;
    }

    @Override
    public void addCanScrollKeysUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysUp() instead");
        this.mCanScrollKeysUp.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollKeysDown() {
        this.newSince(2);
        return this.mCanScrollKeysDown;
    }

    @Override
    public void addCanScrollKeysDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollKeysDown() instead");
        this.mCanScrollKeysDown.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsBackwards() {
        this.newSince(2);
        return this.mCanScrollStepsBackwards;
    }

    @Override
    public void addCanScrollStepsBackwardsObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsBackwards() instead");
        this.mCanScrollStepsBackwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public BooleanValue canScrollStepsForwards() {
        this.newSince(2);
        return this.mCanScrollStepsForwards;
    }

    @Override
    public void addCanScrollStepsForwardObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.deprecated(1, 2, "Use canScrollStepsForwards() instead");
        this.mCanScrollStepsForwards.addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void scrollKeysPageUp() {
        this.scrollToKey(Math.max(128 - this.mGridHeight, this.mBaseKey + this.mGridHeight));
    }

    @Override
    public void scrollKeysPageDown() {
        this.scrollToKey(Math.min(0, this.mBaseKey - this.mGridHeight));
    }

    @Override
    public void scrollKeysStepUp() {
        this.scrollToKey(Math.max(128 - this.mGridHeight, this.mBaseKey + 1));
    }

    @Override
    public void scrollKeysStepDown() {
        this.scrollToKey(Math.min(0, this.mBaseKey - 1));
    }

    @Override
    public void scrollToKey(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToKey(n2));
    }

    private void doScrollToKey(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null && this.mBaseKey != n2) {
            this.mBaseKey = n2;
            this.updateGrid();
        }
    }

    @Override
    public void scrollToStep(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doScrollToStep(n2));
    }

    private void doScrollToStep(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null && this.mBaseStep != n2) {
            this.mBaseStep = n2;
            this.updateGrid();
        }
    }

    @Override
    public void setName(String string) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetName(string));
    }

    private void doSetName(String string) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null && bwe2.aIN() != null) {
            bwe2.aIN().rKg(string);
        }
    }

    @Override
    public void scrollStepsPageForward() {
        this.scrollToStep(this.mBaseStep + this.mGridWidth);
    }

    @Override
    public void scrollStepsPageBackwards() {
        this.scrollToStep(this.mBaseStep - this.mGridWidth);
    }

    @Override
    public void scrollStepsStepForward() {
        this.scrollToStep(this.mBaseStep + 1);
    }

    @Override
    public void scrollStepsStepBackwards() {
        this.scrollToStep(this.mBaseStep - 1);
    }

    @Override
    public void toggleStep(int n2, int n3, int n4) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doToggleStep(n2, n3, n4));
    }

    private void doToggleStep(int n2, int n3, int n4) {
        assert (cOY.HSF(this.isDocumentThread()));
        iAt iAt2 = this.getClip();
        if (iAt2 == null) {
            return;
        }
        bwe bwe2 = (bwe)this.getTarget();
        assert (cOY.HSF(bwe2 != null));
        int n5 = n3 + this.mBaseKey;
        double d3 = this.getTimeForCell(n2);
        double d4 = d3 + this.getStepSize() - 1.0E-4;
        if (n5 >= 0 && n5 < 128) {
            smy smy2 = iAt2.HSF().rKg(n5, false);
            List list = smy2 != null ? smy2.HSF(d3, d4) : Collections.EMPTY_LIST;
            bwe2.Kmx().eEF();
            if (list.isEmpty()) {
                iAt2.rKg(d3, this.mStepSize, n5, (float)n4 * 0.007874016f, bwe2.Kmx().jxi());
            } else {
                for (Cug cug2 : list) {
                    smy2.OkB(cug2);
                }
            }
        }
    }

    @Override
    public void setStep(int n2, int n3, int n4, double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doSetStep(n2, n3, n4, d3));
    }

    private void doSetStep(int n2, int n3, int n4, double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        iAt iAt2 = this.getClip();
        if (iAt2 == null) {
            return;
        }
        bwe bwe2 = (bwe)this.getTarget();
        assert (cOY.HSF(bwe2 != null));
        int n5 = n3 + this.mBaseKey;
        double d4 = this.getTimeForCell(n2);
        if (n5 >= 0 && n5 < 128) {
            iAt2.rKg(d4, d3, n5, (float)n4 * 0.007874016f, bwe2.Kmx().jxi());
        }
    }

    @Override
    public void clearStep(int n2, int n3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doClearStep(n2, n3));
    }

    private void doClearStep(int n2, int n3) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            iAt iAt2 = this.getClip();
            if (iAt2 == null) {
                return;
            }
            int n4 = n3 + this.mBaseKey;
            double d3 = this.getTimeForCell(n2);
            double d4 = d3 + this.getStepSize() - 1.0E-4;
            if (n4 >= 0 && n4 < 128) {
                smy smy2 = iAt2.HSF().rKg(n4, false);
                if (smy2 != null) {
                    List list = smy2.HSF(d3, d4);
                    for (Zar zar : list) {
                        smy2.OkB(zar);
                    }
                }
                bwe2.Kmx().eEF();
            }
        }
    }

    @Override
    public void clearSteps() {
        this.exec(() -> this.doClearSteps());
    }

    private void doClearSteps() {
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            iAt iAt2 = this.getClip();
            if (iAt2 == null) {
                return;
            }
            iAt2.OkB().jWS(-1.7976931348623157E308, Double.MAX_VALUE);
            bwe2.Kmx().eEF();
        }
    }

    @Override
    public void clearSteps(int n2) {
        this.exec(() -> this.doClearSteps(n2));
    }

    private void doClearSteps(int n2) {
        assert (cOY.jWS(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            smy smy2;
            iAt iAt2 = this.getClip();
            if (iAt2 == null) {
                return;
            }
            int n3 = n2 + this.mBaseKey;
            if (n3 >= 0 && n3 < 128 && (smy2 = iAt2.HSF().rKg(n3, false)) != null) {
                smy2.hrK();
            }
        }
    }

    @Override
    public void selectStepContents(int n2, int n3, boolean bl2) {
        this.exec(() -> this.doSelectStepContents(n2, n3, bl2));
    }

    private void doSelectStepContents(int n2, int n3, boolean bl2) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            iAt iAt2 = this.getClip();
            if (iAt2 == null) {
                return;
            }
            int n4 = n3 + this.mBaseKey;
            double d3 = this.getTimeForCell(n2);
            double d4 = d3 + this.getStepSize() - 1.0E-4;
            if (n4 >= 0 && n4 < 128) {
                smy smy2 = iAt2.HSF().rKg(n4, false);
                List list = smy2 != null ? smy2.HSF(d3, d4) : Collections.EMPTY_LIST;
                bdP bdP2 = bwe2.Kmx();
                if (bl2) {
                    bdP2.eEF();
                }
                for (uY3 uY32 : list) {
                    bdP2.aXU(uY32.rKg(0, false));
                }
            }
        }
    }

    @Override
    public void setStepSize(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (d3 <= 0.0) {
            throw new Q3u("step size must be > 0");
        }
        this.exec(() -> this.doSetStepSize(d3));
    }

    private void doSetStepSize(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (this.mStepSize != d3) {
            this.mStepSize = d3;
            this.mStepGrid = new wDp(this.mStepSize);
            if (!this.mHasInvalidatedGrid && bwe2 != null) {
                this.mHasInvalidatedGrid = true;
                if (this.mUpdateStepGridTimer != null) {
                    this.mUpdateStepGridTimer.cancel();
                }
                this.mUpdateStepGridTimer = new Timer("Update Step Grid");
                this.mUpdateStepGridTimer.schedule((TimerTask)new ClipProxy$1(this), 100L);
            }
        }
    }

    private double getStepSize() {
        return this.mStepSize;
    }

    private double getTimeForCell(int n2) {
        return (double)(this.mBaseStep + n2) * this.getStepSize();
    }

    private int getKeyForY(int n2) {
        return this.mBaseKey + n2;
    }

    private iAt getClip() {
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null && bwe2.aIN() instanceof iAt) {
            return (iAt)bwe2.aIN();
        }
        return null;
    }

    private void invalidateGrid() {
        if (!this.mHasInvalidatedGrid) {
            this.mHasInvalidatedGrid = true;
            cj.u1q().HSF(new ClipProxy$2(this));
        }
    }

    private void updateGrid() {
        assert (cOY.HSF(this.isDocumentThread()));
        iAt iAt2 = this.getClip();
        bwe bwe2 = (bwe)this.getTarget();
        for (int i2 = 0; i2 < this.mGridWidth; ++i2) {
            double d3 = this.getTimeForCell(i2);
            double d4 = d3 + this.getStepSize() - 1.0E-4;
            List list = Collections.emptyList();
            if (iAt2 != null) {
                assert (cOY.jWS(iAt2.Ysu().p_()));
                list = pdG.rKg(iAt2.HSF().aXU(), d3, d4);
            }
            for (int i3 = 0; i3 < this.mGridHeight; ++i3) {
                ClipProxy$Step clipProxy$Step = (ClipProxy$Step)this.mSteps.get(i2 + i3 * this.mGridWidth);
                int n2 = this.getKeyForY(i3);
                int n3 = 0;
                boolean bl2 = false;
                for (Cug cug2 : list) {
                    Zar zar = (Zar)cug2;
                    if (zar.OkB() != n2) continue;
                    int n4 = n3 = zar.lVt() >= d3 ? 2 : 1;
                    if (!bwe2.Kmx().rKg(zar)) continue;
                    bl2 = true;
                }
                clipProxy$Step.setNoteState(n3);
                clipProxy$Step.setHasSelectedNote(bl2);
            }
        }
        this.mCanScrollKeysDown.setBoolValue(this.mBaseKey > 0);
        this.mCanScrollKeysUp.setBoolValue(this.mBaseKey < 128 - this.mGridWidth * this.mGridHeight);
    }

    @Override
    public void addStepDataObserver(StepDataChangedCallback stepDataChangedCallback) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.checkIsInitializingDriver();
        this.notNull(stepDataChangedCallback, "callback");
        this.mStepDataChangedCallbacks.add(stepDataChangedCallback);
    }

    @Override
    public IntegerValue playingStep() {
        this.newSince(2);
        return this.mPlayingStep;
    }

    @Override
    public void addPlayingStepObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.deprecated(1, 2, "Use playingStep() instead");
        this.mPlayingStep.addValueObserver(integerValueChangedCallback);
    }

    @Override
    public SettableBooleanValueProxy getShuffle() {
        return this.mShuffle;
    }

    @Override
    public SettableRangedValue getAccent() {
        return this.mAccent;
    }

    @Override
    public SettableBeatTimeValue getPlayStart() {
        return this.mPlayStart;
    }

    @Override
    public SettableBeatTimeValue getPlayStop() {
        return this.mPlayStop;
    }

    @Override
    public SettableBooleanValueProxy isLoopEnabled() {
        return this.mIsLoopEnabled;
    }

    @Override
    public SettableBeatTimeValue getLoopStart() {
        return this.mLoopStart;
    }

    @Override
    public SettableBeatTimeValue getLoopLength() {
        return this.mLoopLength;
    }

    @Override
    public void addColorObserver(ColorValueChangedCallback colorValueChangedCallback) {
        this.deprecated(1, 2, "Use color().addValueObserver(callback)");
        this.mColor.addValueObserver(colorValueChangedCallback);
    }

    @Override
    public SettableColorValue color() {
        this.newSince(2);
        return this.mColor;
    }

    @Override
    public void duplicate() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(this::doDuplicate);
    }

    private void doDuplicate() {
        assert (cOY.HSF(this.isDocumentThread()));
        UZ3 uZ3 = this.getDocument();
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null && uZ3 != null) {
            So so2 = bwe2.aIN();
            lGO lGO2 = (lGO)so2.jWS(lGO.class);
            if (lGO2 != null) {
                DDM dDM2 = uZ3.XPF().HSF();
                dDM2.JeD(lGO2);
                dDM2.r2h();
                if (dDM2.NJt()) {
                    dDM2.nVg();
                }
            }
            so2.aaG();
        }
    }

    @Override
    public void duplicateContent() {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(this::doDuplicateContent);
    }

    private void doDuplicateContent() {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            bwe2.aIN().aaG();
        }
    }

    @Override
    public void transpose(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.exec(() -> this.doTranspose(n2));
    }

    private void doTranspose(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            bwe2.aIN().rKg(n2);
        }
    }

    @Override
    public void quantize(double d3) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (d3 <= 0.0 || d3 > 1.0) {
            throw new Q3u("Clip.quantize: amount parameter value should be greater than zero and maximal one.");
        }
        this.exec(() -> this.doQuantize(d3));
    }

    private void doQuantize(double d3) {
        assert (cOY.HSF(this.isDocumentThread()));
        bwe bwe2 = (bwe)this.getTarget();
        if (bwe2 != null) {
            bwe2.rKg(d3, this.mStepGrid);
        }
    }

    @Override
    public Track getTrack() {
        return this.mTrackSection;
    }

    protected void connectToTarget(bwe bwe2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(bwe2 != null));
        So so2 = bwe2.aIN();
        Jl jl2 = so2.u1q();
        iAt iAt2 = this.getClip();
        if (iAt2 != null) {
            iAt2.OkB().HSF(this.mPlaybackPositionListener);
            iAt2.D31().rKg(this.mHierarchyListener);
        }
        bwe2.Kmx().RlA().rKg(this.mSelectionChangeListener);
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.setTarget(so2.sAD().CqD());
        }
        this.updateGrid();
        this.mShuffle.setTarget(jl2.pf_());
        this.mAccent.setTarget(jl2.sAD());
        VPY vPY = jl2.JeD();
        this.mPlayStart.setTarget(vPY.bn_().aIN());
        this.mPlayStop.setTarget(vPY.OkB().aIN());
        this.mIsLoopEnabled.setTarget(vPY.fh1());
        this.mLoopStart.setTarget(vPY.JeD().aIN());
        this.mLoopLength.setTarget(vPY.JeD().GUf());
        this.mColor.setTarget(so2.hrK());
        this.mColor.setEditableValue(so2.hMn());
        if (this.mTrackSection != null) {
            lGO lGO2;
            ClipLauncherSlotBankProxy clipLauncherSlotBankProxy = this.mTrackSection.getClipLauncherSlots();
            xwW xwW2 = so2.Bsf();
            this.mTrackSection.setTarget(xwW2);
            if (clipLauncherSlotBankProxy != null && (lGO2 = (lGO)so2.jWS(lGO.class)) != null) {
                clipLauncherSlotBankProxy.scrollToScene(lGO2);
            }
        }
        this.connectObservers(so2);
    }

    protected void disconnectFromTarget(bwe bwe2) {
        assert (cOY.HSF(bwe2 != null));
        So so2 = bwe2.aIN();
        this.disconnectObservers(so2);
        iAt iAt2 = this.getClip();
        if (this.mTrackSection != null) {
            this.mTrackSection.clearTarget();
        }
        if (iAt2 != null) {
            iAt2.OkB().jWS(this.mPlaybackPositionListener);
            iAt2.D31().OkB(this.mHierarchyListener);
        }
        Jl jl2 = so2.u1q();
        VPY vPY = jl2.JeD();
        this.mPlayStart.clearTarget();
        this.mPlayStop.clearTarget();
        this.mIsLoopEnabled.clearTarget();
        this.mLoopStart.clearTarget();
        this.mLoopLength.clearTarget();
        this.mColor.clearTarget();
        this.mShuffle.clearTarget();
        this.mAccent.clearTarget();
        if (this.mNoteLanes != null) {
            this.mNoteLanesBankUpdater.clearTarget();
        }
        bwe2.Kmx().RlA().OkB(this.mSelectionChangeListener);
        this.updateGrid();
        this.setPlayingStep(-1);
    }

    private void sendNoteStateToObservers(int n2, int n3, int n4) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.queueCallback(() -> this.notifyStepDataObservers(n2, n3, n4));
    }

    private void notifyStepDataObservers(int n2, int n3, int n4) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        for (StepDataChangedCallback stepDataChangedCallback : this.mStepDataChangedCallbacks) {
            stepDataChangedCallback.stepStateChanged(n2, n3, n4);
        }
    }

    private void setPlayingStep(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(n2 >= -1));
        if (n2 != this.mLastPlaybackStep) {
            this.mLastPlaybackStep = n2;
            this.mPlayingStep.setIntegerValue(n2);
        }
    }

    static /* synthetic */ void access$000(ClipProxy clipProxy) {
        clipProxy.updateGrid();
    }

    static /* synthetic */ boolean access$102(ClipProxy clipProxy, boolean bl2) {
        clipProxy.mHasInvalidatedGrid = bl2;
        return clipProxy.mHasInvalidatedGrid;
    }

    static /* synthetic */ Timer access$202(ClipProxy clipProxy, Timer timer) {
        clipProxy.mUpdateStepGridTimer = timer;
        return clipProxy.mUpdateStepGridTimer;
    }

    static /* synthetic */ void access$300(ClipProxy clipProxy, int n2, int n3, int n4) {
        clipProxy.sendNoteStateToObservers(n2, n3, n4);
    }

    static /* synthetic */ double access$400(ClipProxy clipProxy) {
        return clipProxy.getStepSize();
    }

    static /* synthetic */ void access$500(ClipProxy clipProxy, int n2) {
        clipProxy.setPlayingStep(n2);
    }

    static /* synthetic */ void access$600(ClipProxy clipProxy) {
        clipProxy.invalidateGrid();
    }
}

