/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.callback.BooleanValueChangedCallback;
import com.bitwig.extension.callback.IntegerValueChangedCallback;
import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.BrowserItem;
import com.bitwig.extension.controller.api.BrowserItemBank;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BrowserColumnProxy;
import com.bitwig.flt.control_surface.proxy.BrowserItemProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObjectProxy;
import com.bitwig.flt.control_surface.proxy.ListValueBankItemTargetUpdater;

public abstract class BrowserItemBankProxy
extends ControlSurfaceObjectProxy
implements BrowserItemBank {
    private final ListValueBankItemTargetUpdater mBankUpdater;
    protected BrowserItemProxy[] mItemProxies;
    protected final int mSize;

    public BrowserItemBankProxy(BrowserColumnProxy browserColumnProxy, int n2) {
        super(browserColumnProxy);
        if (n2 < 1) {
            throw new Q3u("Item bank size must be >= 1");
        }
        this.mSize = n2;
        this.mItemProxies = new BrowserItemProxy[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mItemProxies[i2] = this.createResultProxy(i2, browserColumnProxy);
        }
        this.mBankUpdater = new ListValueBankItemTargetUpdater((ControlSurfaceObject)this, this.mItemProxies);
    }

    public BrowserColumnProxy getColumn() {
        return (BrowserColumnProxy)this.getParent();
    }

    protected abstract BrowserItemProxy createResultProxy(int var1, BrowserColumnProxy var2);

    @Override
    public int getSizeOfBank() {
        return this.mSize;
    }

    @Override
    public int getSize() {
        return this.mSize;
    }

    @Override
    public IntegerValue itemCount() {
        return this.mBankUpdater.getListItemCount();
    }

    @Override
    public SettableIntegerValue cursorIndex() {
        return this.mBankUpdater.getCursorIndex();
    }

    @Override
    public SettableIntegerValue scrollPosition() {
        return this.mBankUpdater.getScrollPosition();
    }

    @Override
    public void scrollBy(int n2) {
        this.mBankUpdater.scrollBy(n2);
    }

    @Override
    public void scrollByPages(int n2) {
        this.mBankUpdater.scrollByPages(n2);
    }

    @Override
    public BooleanValue canScrollBackwards() {
        return this.mBankUpdater.getCanScrollBackwards();
    }

    @Override
    public BooleanValue canScrollForwards() {
        return this.mBankUpdater.getCanScrollForwards();
    }

    @Override
    public BrowserItem getItemAt(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return (BrowserItem)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public BrowserItem getItem(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return (BrowserItem)((Object)this.mBankUpdater.getItemAt(n2));
    }

    @Override
    public void scrollUp() {
        this.mBankUpdater.scrollBy(-1);
    }

    @Override
    public void scrollDown() {
        this.mBankUpdater.scrollBy(1);
    }

    @Override
    public void scrollPageUp() {
        this.mBankUpdater.scrollByPages(-1);
    }

    @Override
    public void scrollPageDown() {
        this.mBankUpdater.scrollByPages(1);
    }

    @Override
    public void addScrollPositionObserver(IntegerValueChangedCallback integerValueChangedCallback) {
        this.mBankUpdater.getScrollPosition().addValueObserver(integerValueChangedCallback);
    }

    @Override
    public void addCanScrollUpObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mBankUpdater.getCanScrollBackwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    public void addCanScrollDownObserver(BooleanValueChangedCallback booleanValueChangedCallback) {
        this.mBankUpdater.getCanScrollForwards().addValueObserver(booleanValueChangedCallback);
    }

    @Override
    protected void connectToTarget(Object object) {
        Ipa ipa = this.getResultsListValue(object);
        assert (cOY.HSF(ipa != null));
        this.mBankUpdater.setTarget(ipa);
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        this.mBankUpdater.clearTarget();
    }

    protected abstract Ipa getResultsListValue(Object var1);

    public void scrollToItem(nk nk2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(nk2 != null));
        Object object = this.getTarget();
        if (object != null) {
            Ipa ipa = this.getResultsListValue(object);
            assert (cOY.HSF(ipa != null));
            int n2 = ipa.h_(nk2);
            if (n2 >= 0) {
                this.mBankUpdater.doScrollTo(n2);
            }
        }
    }
}

