/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.control_surface.proxy;

import com.bitwig.extension.controller.api.BooleanValue;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.flt.control_surface.proxy.BankCursorIndex;
import com.bitwig.flt.control_surface.proxy.BankItemWithPosition;
import com.bitwig.flt.control_surface.proxy.BankScrollPosition;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceCursorProxy;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceObject;
import com.bitwig.flt.control_surface.proxy.ControlSurfaceProxy;
import com.bitwig.flt.control_surface.values.ComputedBooleanValue;
import com.bitwig.flt.control_surface.values.ComputedIntegerValue;
import com.bitwig.ramona.core.MtY;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BankItemTargetUpdater
extends ControlSurfaceProxy
implements gMg {
    private final ControlSurfaceProxy[] mItemProxies;
    private final ComputedBooleanValue mCanScrollBackwards;
    private final ComputedBooleanValue mCanScrollForwards;
    private final BankScrollPosition mScrollPosition;
    private final BankCursorIndex mCursorIndex;
    private ControlSurfaceCursorProxy mCursorProxyToFollow;
    private final ComputedIntegerValue mListItemCount;
    private final int mScrollPositionThatPageShouldAlignTo;
    private boolean mHasScheduledUpdate;
    private MtY mCursor;
    private List mScrollPositionSlaves;
    private BankItemTargetUpdater mMasterScrollPositionBankUpdater;

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray, int n2) {
        super(controlSurfaceObject);
        assert (cOY.HSF(controlSurfaceProxyArray != null));
        assert (cOY.HSF(n2 >= 0));
        this.mItemProxies = controlSurfaceProxyArray;
        this.mCanScrollBackwards = new ComputedBooleanValue(this);
        this.mCanScrollForwards = new ComputedBooleanValue(this);
        this.mScrollPosition = new BankScrollPosition(this);
        this.mCursorIndex = new BankCursorIndex(this);
        this.mListItemCount = new ComputedIntegerValue((ControlSurfaceObject)this, 0);
        this.mScrollPositionThatPageShouldAlignTo = n2;
    }

    public BankItemTargetUpdater(ControlSurfaceObject controlSurfaceObject, ControlSurfaceProxy[] controlSurfaceProxyArray) {
        this(controlSurfaceObject, controlSurfaceProxyArray, 0);
    }

    public int getSizeOfBank() {
        return this.mItemProxies.length;
    }

    public ControlSurfaceProxy getItemAt(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        return (ControlSurfaceProxy)this.returnArrayItem(this.mItemProxies, n2);
    }

    public void scrollTo(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        this.postEvent(new Rq(this, Math.max(0, n2), true));
    }

    public void doScrollTo(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(n2 >= 0));
        if (this.mMasterScrollPositionBankUpdater != null) {
            this.mMasterScrollPositionBankUpdater.doScrollTo(n2);
        } else {
            this.doScrollToImpl(n2);
        }
    }

    protected int quantizePosition(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        int n3 = this.mItemProxies.length;
        int n4 = n3 < this.mScrollPositionThatPageShouldAlignTo ? this.mScrollPositionThatPageShouldAlignTo % n3 : 0;
        int n5 = (n2 - n4) / n3 * n3 + n4;
        int n6 = this.mListItemCount.getValue();
        if (n5 < this.mScrollPosition.getValue() - n3) {
            n5 += n3;
        }
        int n7 = (n6 - 1) / n3 * n3;
        return gxQ.rKg(n5, 0, n7);
    }

    private void doScrollToImpl(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        int n3 = gxQ.rKg(n2, 0, Math.max(0, this.mListItemCount.getValue() - this.mItemProxies.length));
        List list = this.getList();
        int n4 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n5 = n3 + i2;
            if (n5 < list.size()) {
                object = (MtY)list.get(n5);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && this.mCursor == object) {
                    n4 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n5);
        }
        if (this.mScrollPositionSlaves != null) {
            for (ControlSurfaceProxy controlSurfaceProxy : this.mScrollPositionSlaves) {
                super.doScrollToImpl(n3);
            }
        }
        this.mScrollPosition.setIntegerValue(n3);
        if (n4 >= 0) {
            this.mCursorIndex.setIntegerValue(n4);
        } else {
            this.mCursorIndex.unassigned();
        }
        this.mCanScrollForwards.setBoolValue(n3 + this.mItemProxies.length < list.size());
        this.mCanScrollBackwards.setBoolValue(n3 > 0);
    }

    public void scrollBy(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.postEvent(new Rq(this, n2, false));
        }
    }

    public void doScrollBy(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.doScrollTo(Math.max(0, this.mScrollPosition.getValue() + n2));
    }

    public void scrollByPages(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (n2 != 0) {
            this.exec(() -> this.doScrollByPages(n2));
        }
    }

    private void doScrollByPages(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        this.doScrollBy(n2 * this.mItemProxies.length);
    }

    public ControlSurfaceProxy[] getItemProxies() {
        return this.mItemProxies;
    }

    public BooleanValue getCanScrollForwards() {
        return this.mCanScrollForwards;
    }

    public BooleanValue getCanScrollBackwards() {
        return this.mCanScrollBackwards;
    }

    public IntegerValue getListItemCount() {
        return this.mListItemCount;
    }

    public SettableIntegerValue getScrollPosition() {
        return this.mScrollPosition;
    }

    public int getScrollPositionValue() {
        assert (cOY.HSF(this.isDocumentThread()));
        return this.mScrollPosition.getValue();
    }

    public void listChanged() {
        assert (cOY.HSF(this.isDocumentThread()));
        if (!this.mHasScheduledUpdate) {
            this.mHasScheduledUpdate = true;
            this.runAtEndOfEvent(this::update);
        }
    }

    private void update() {
        assert (cOY.HSF(this.isDocumentThread()));
        List list = this.getList();
        this.update(list);
        this.mHasScheduledUpdate = false;
    }

    @Override
    protected void connectToTarget(Object object) {
        this.update();
    }

    @Override
    protected void disconnectFromTarget(Object object) {
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            controlSurfaceProxy.clearTarget();
        }
    }

    private List getList() {
        assert (cOY.HSF(this.isDocumentThread()));
        Object object = this.getTarget();
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        return this.calculateList(object);
    }

    protected abstract List calculateList(Object var1);

    protected void update(List list) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(list != null));
        int n2 = list.size() <= this.mItemProxies.length ? 0 : this.determineNewOffset(list);
        assert (cOY.HSF(n2 >= 0));
        assert (cOY.HSF(this.mItemProxies.length < list.size() ? n2 + this.mItemProxies.length <= list.size() : n2 == 0));
        int n3 = -1;
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            Object object;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            int n4 = n2 + i2;
            if (n4 < list.size()) {
                object = (MtY)list.get(n4);
                controlSurfaceProxy.setTarget(object);
                if (this.mCursor != null && object == this.mCursor) {
                    n3 = i2;
                }
            } else {
                controlSurfaceProxy.clearTarget();
            }
            if (!(controlSurfaceProxy instanceof BankItemWithPosition)) continue;
            object = ((BankItemWithPosition)((Object)controlSurfaceProxy)).getBankItemPosition();
            ((ComputedIntegerValue)object).setIntegerValue(n4);
        }
        Object object = this.getTarget();
        if (object != null) {
            this.mScrollPosition.setIntegerValue(n2);
            this.mListItemCount.setIntegerValue(list.size());
            this.mCanScrollForwards.setBoolValue(n2 + this.mItemProxies.length < list.size());
            this.mCanScrollBackwards.setBoolValue(n2 > 0);
        } else {
            this.mScrollPosition.unassigned();
            this.mListItemCount.unassigned();
            this.mCanScrollForwards.unassigned();
            this.mCanScrollBackwards.unassigned();
        }
        if (n3 >= 0) {
            this.mCursorIndex.setIntegerValue(n3);
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    private int determineNewOffset(List list) {
        assert (cOY.HSF(list.size() >= this.mItemProxies.length));
        assert (cOY.HSF(this.isDocumentThread()));
        for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
            int n2;
            ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
            MtY mtY = (MtY)controlSurfaceProxy.getTarget();
            if (mtY == null || (n2 = list.indexOf(mtY)) < 0) continue;
            return gxQ.rKg(n2, 0, list.size() - this.mItemProxies.length);
        }
        return gxQ.rKg(this.mScrollPosition.getValue(), 0, list.size() - this.mItemProxies.length);
    }

    public void addScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (cOY.HSF(bankItemTargetUpdater != null));
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInitializingDriver()));
        if (this.mScrollPositionSlaves == null) {
            this.mScrollPositionSlaves = new ArrayList(8);
        }
        this.mScrollPositionSlaves.add(bankItemTargetUpdater);
        assert (cOY.HSF(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == null));
        bankItemTargetUpdater.mMasterScrollPositionBankUpdater = this;
    }

    public void removeScrollPositionSlave(BankItemTargetUpdater bankItemTargetUpdater) {
        assert (cOY.HSF(bankItemTargetUpdater != null));
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(this.isInitializingDriver()));
        assert (cOY.HSF(this.mScrollPositionSlaves != null));
        if (this.mScrollPositionSlaves != null) {
            assert (cOY.HSF(this.mScrollPositionSlaves.contains(bankItemTargetUpdater)));
            this.mScrollPositionSlaves.remove(bankItemTargetUpdater);
            assert (cOY.HSF(bankItemTargetUpdater.mMasterScrollPositionBankUpdater == this));
            bankItemTargetUpdater.mMasterScrollPositionBankUpdater = null;
        }
    }

    @Override
    public MtY getFirstItem(MtY mtY) {
        assert (cOY.HSF(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (MtY)list.get(0);
        }
        return null;
    }

    @Override
    public MtY getLastItem(MtY mtY) {
        assert (cOY.HSF(this.isDocumentThread()));
        List list = this.getList();
        if (!list.isEmpty()) {
            return (MtY)list.get(list.size() - 1);
        }
        return null;
    }

    @Override
    public MtY getPreviousItem(MtY mtY) {
        assert (cOY.HSF(this.isDocumentThread()));
        List list = this.getList();
        if (mtY == null) {
            if (!list.isEmpty()) {
                return (MtY)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(mtY);
        if (n2 > 0) {
            return (MtY)list.get(n2 - 1);
        }
        return null;
    }

    @Override
    public MtY getNextItem(MtY mtY) {
        assert (cOY.HSF(this.isDocumentThread()));
        List list = this.getList();
        if (mtY == null) {
            if (!list.isEmpty()) {
                return (MtY)list.get(0);
            }
            return null;
        }
        int n2 = list.indexOf(mtY);
        if (n2 + 1 < list.size()) {
            return (MtY)list.get(n2 + 1);
        }
        return null;
    }

    protected void cursorMovedToItem(MtY mtY) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(this.mCursorProxyToFollow != null));
        this.mCursor = mtY;
        if (mtY != null) {
            this.doScrollToItem(mtY);
            int n2 = -1;
            for (int i2 = 0; i2 < this.mItemProxies.length; ++i2) {
                ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[i2];
                MtY mtY2 = (MtY)controlSurfaceProxy.getTarget();
                if (mtY2 != mtY) continue;
                n2 = i2;
                break;
            }
            if (n2 >= 0) {
                this.mCursorIndex.setIntegerValue(n2);
            } else {
                this.mCursorIndex.unassigned();
            }
        } else {
            this.mCursorIndex.unassigned();
        }
    }

    public void doScrollToItem(MtY mtY) {
        int n2;
        assert (cOY.HSF(mtY != null));
        assert (cOY.HSF(this.isDocumentThread()));
        List list = this.getList();
        int n3 = list.indexOf(mtY);
        if (n3 >= 0 && (n3 < (n2 = this.mScrollPosition.getValue()) || n3 >= n2 + this.mItemProxies.length)) {
            int n4 = this.quantizePosition(n3);
            assert (cOY.HSF(n3 >= n4 && n3 < n4 + this.mItemProxies.length));
            this.doScrollTo(n4);
        }
    }

    public void followCursorProxy(ControlSurfaceCursorProxy controlSurfaceCursorProxy) {
        this.notNull(controlSurfaceCursorProxy, "cursor");
        this.checkIsInitializingDriver();
        if (this.mCursorProxyToFollow != null) {
            throw new Q3u("This bank is already following a cursor");
        }
        this.mCursorProxyToFollow = controlSurfaceCursorProxy;
        controlSurfaceCursorProxy.addBankFollowingCursor(this);
    }

    public SettableIntegerValue getCursorIndex() {
        assert (cOY.HSF(this.mCursorIndex != null));
        return this.mCursorIndex;
    }

    protected void moveCursorIndexTo(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        assert (cOY.HSF(n2 >= 0 && n2 < this.getSizeOfBank()));
        if (this.mCursorProxyToFollow == null) {
            throw new Q3u("This bank is not following any cursor");
        }
        this.exec(() -> this.doMoveCursorToIndex(n2));
    }

    private void doMoveCursorToIndex(int n2) {
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(n2 >= 0 && n2 < this.getSizeOfBank()));
        assert (cOY.HSF(this.mCursorProxyToFollow != null));
        ControlSurfaceProxy controlSurfaceProxy = this.mItemProxies[n2];
        MtY mtY = (MtY)controlSurfaceProxy.getTarget();
        if (mtY != null) {
            this.mCursorProxyToFollow.doSelect(mtY);
        }
    }

    protected void moveCursorIndexBy(int n2) {
        assert (cOY.HSF(this.isControlSurfaceThread()));
        if (this.mCursorProxyToFollow == null) {
            throw new Q3u("This bank is not following any cursor");
        }
        if (n2 != 0) {
            this.exec(() -> this.doMoveCursorIndexBy(n2));
        }
    }

    private void doMoveCursorIndexBy(int n2) {
        int n3;
        assert (cOY.HSF(this.isDocumentThread()));
        assert (cOY.HSF(n2 != 0));
        assert (cOY.HSF(this.mCursorProxyToFollow != null));
        int n4 = this.mCursorIndex.getValue();
        assert (cOY.HSF(n4 >= 0 && n4 < this.getSizeOfBank() || n4 == -1));
        if (n4 >= 0 && n4 < this.getSizeOfBank() && (n3 = n4 + n2) >= 0 && n3 < this.getSizeOfBank()) {
            this.doMoveCursorToIndex(n3);
        }
    }
}

