/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.platform;

import com.bitwig.base.io.ProcessException;
import com.bitwig.base.io.cj;
import com.bitwig.base.io.fOm;
import com.bitwig.base.io.tmH;
import com.bitwig.base.platform.MacOsXIoKit;
import com.bitwig.base.platform.WindowsPlatform;
import com.bitwig.base.platform.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;

public final class Platform {
    private static String OkB;
    private static UUID HSF;
    private static boolean jWS;
    private static File aXU;
    private static File jxi;

    public static void rKg() {
        if (!jWS) {
            IYH.OkB("base-platform");
            jWS = true;
        }
    }

    public static String OkB() {
        if (OkB == null) {
            OkB = Platform.fh1();
        }
        assert (cOw.OkB(OkB != null));
        assert (cOw.OkB(!OkB.isEmpty()));
        return OkB;
    }

    private static String fh1() {
        if (IYH.OkB()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            String string2 = Platform.getNativeComputerName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                cOw.rKg.jWS("Warning: determining macOS host name failed, using fallback instead.");
                string2 = InetAddress.getLocalHost().getHostName();
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                cOw.rKg.jWS("Error: unable to determine macOS host name.");
            }
        } else if (IYH.rKg()) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = System.getenv("COMPUTERNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
        } else if (IYH.jWS()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            try {
                String string3 = InetAddress.getLocalHost().getHostName();
                if (string3 != null && !string3.isEmpty()) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "localhost";
    }

    private static native String getNativeComputerName();

    public static UUID HSF() {
        if (HSF == null) {
            HSF = Platform.JeD();
        }
        assert (cOw.OkB(HSF != null));
        return HSF;
    }

    private static UUID JeD() {
        if (IYH.rKg()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483646, "SOFTWARE\\Microsoft\\Cryptography", "MachineGuid");
            return UUID.fromString(string);
        }
        if (IYH.OkB()) {
            String string = MacOsXIoKit.readRegistryStringValue("IOPlatformUUID");
            return UUID.fromString(string);
        }
        if (IYH.jWS()) {
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[]{57, 22, 57, 79, 57, 88, 57, 75, 57, 22, 57, 85, 57, 80, 57, 91, 57, 22, 57, 93, 57, 91, 57, 76, 57, 74, 57, 22, 57, 84, 57, 88, 57, 90, 57, 81, 57, 80, 57, 87, 57, 92, 57, 20, 57, 80, 57, 93};
                String string = xd.rKg(byArray2);
                File file = null;
                File file2 = new File(string);
                if (file2.isFile()) {
                    file = file2;
                } else {
                    byArray = new byte[]{57, 22, 57, 92, 57, 77, 57, 90, 57, 22, 57, 84, 57, 88, 57, 90, 57, 81, 57, 80, 57, 87, 57, 92, 57, 20, 57, 80, 57, 93};
                    String string2 = xd.rKg(byArray);
                    file = new File(string2);
                }
                byArray = fOm.fh1(file);
                return UUID.nameUUIDFromBytes(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void jWS() {
        Thread.currentThread().setPriority(1);
        if (!IYH.rKg()) {
            Platform.initThreadForBackgroundIONative();
        }
    }

    private static native void initThreadForBackgroundIONative();

    public static void rKg(File file) {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (IYH.jWS()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file.getAbsolutePath());
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (IYH.OkB()) {
            ProcessBuilder processBuilder = file.isDirectory() ? new ProcessBuilder("open", "-R", file.getAbsolutePath()) : new ProcessBuilder("open", file.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open " + file.getAbsolutePath() + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (IYH.rKg() && !WindowsPlatform.rKg(file.getAbsolutePath())) {
            throw new IOException("Couldn't open file: " + file.getAbsolutePath());
        }
    }

    public static void rKg(String string) {
        if (IYH.jWS()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", string);
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n2 = process.waitFor();
                if (n2 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n2);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (IYH.OkB()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", string);
            Process process = processBuilder.start();
            try {
                int n3 = process.waitFor();
                if (n3 != 0) {
                    throw new IOException("open " + string + " returned error exit code " + n3);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (IYH.rKg() && !WindowsPlatform.rKg(string)) {
            throw new IOException("Couldn't open URL: " + string);
        }
    }

    public static String aXU() {
        try {
            if (IYH.jWS()) {
                return Platform.u1q();
            }
            if (IYH.rKg()) {
                return Platform.sAD();
            }
            if (IYH.OkB()) {
                return Platform.lpO();
            }
        }
        catch (Throwable throwable) {
            cOw.rKg.OkB(throwable);
        }
        return null;
    }

    private static String lpO() {
        try {
            cj cj2 = tmH.rKg(new String[]{"sw_vers"}, null);
            if (cj2.rKg() == 0) {
                String string = cj2.OkB();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            return null;
        }
    }

    private static String sAD() {
        try {
            cj cj2 = tmH.rKg(new String[]{"systeminfo"}, null);
            if (cj2.rKg() == 0) {
                String string = cj2.OkB();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            cOw.rKg.OkB(processException);
            return null;
        }
    }

    private static String u1q() {
        String string = Platform.wj2();
        String string2 = Platform.IsU();
        return string + "\n" + string2;
    }

    private static String wj2() {
        try {
            cj cj2 = tmH.rKg(new String[]{"lsb_release", "-a"}, null);
            if (cj2.rKg() == 0) {
                String string = cj2.OkB();
                return string;
            }
            return "";
        }
        catch (ProcessException processException) {
            return "";
        }
    }

    private static String IsU() {
        try {
            return fOm.rKg(new FileReader(new File("/proc/cpuinfo")));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static File jxi() {
        return aXU;
    }

    public static File CqD() {
        return jxi;
    }

    public static native void simulateCrashInNativeCode();

    public static File OkB(String string) {
        if (IYH.rKg()) {
            return Platform.jxi(string);
        }
        if (IYH.OkB()) {
            return Platform.aXU(string);
        }
        if (IYH.jWS()) {
            return Platform.jWS(string);
        }
        assert (cOw.OkB(false));
        return null;
    }

    private static File jWS(String string) {
        File file = new File("/media/" + string);
        if (!file.isDirectory()) {
            String string2 = System.getProperty("user.name");
            file = new File("/media/" + string2 + "/" + string);
            if (!(file.isDirectory() || (file = new File("/mnt/" + string)).isDirectory() || (file = new File("/mnt/" + string2 + "/" + string)).isDirectory())) {
                return null;
            }
        }
        return file;
    }

    private static File aXU(String string) {
        File file = new File("/Volumes/" + string);
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File jxi(String string) {
        File file;
        FileStore fileStore;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.type().equals("UDF") && !fileStore.type().equals("CDFS") || !fileStore.name().toLowerCase().startsWith(string.toLowerCase())) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.name().equalsIgnoreCase(string)) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static File HSF(String string) {
        if (IYH.rKg()) {
            return Platform.fh1(string);
        }
        if (IYH.OkB()) {
            return Platform.CqD(string);
        }
        if (IYH.jWS()) {
            return Platform.JeD(string);
        }
        assert (cOw.OkB(false));
        return null;
    }

    private static File CqD(String string) {
        File file = new File("/Volumes");
        return Platform.rKg(file, string);
    }

    private static File rKg(File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File file3 = new File(file2, string);
                if (!file3.isDirectory()) continue;
                return file3;
            }
        }
        return null;
    }

    private static File fh1(String string) {
        File file;
        Object object;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                File file2;
                object = Files.getFileStore(path);
                file = path.toFile();
                if (!((FileStore)object).type().equals("UDF") && !((FileStore)object).type().equals("CDFS") || !(file2 = new File(file, string)).isDirectory()) continue;
                return file2;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            object = path.toFile();
            file = new File((File)object, string);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private static File JeD(String string) {
        String string2 = System.getProperty("user.name");
        File file = Platform.rKg(new File("/media/" + string2), string);
        if (file == null && (file = Platform.rKg(new File("/media"), string)) == null && (file = Platform.rKg(new File("/mnt/" + string2), string)) == null) {
            file = Platform.rKg(new File("/mnt"), string);
        }
        return file;
    }

    static {
        Platform.rKg();
        if (IYH.rKg()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "DESKTOP");
            aXU = string != null && !string.isEmpty() ? new File(string) : new File(fOm.OkB(), "Desktop");
            String string2 = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
            if (string2 != null && !string2.isEmpty()) {
                jxi = new File(string2);
            } else {
                aXU = new File(fOm.OkB(), "Documents");
            }
        } else {
            aXU = new File(fOm.OkB(), "Desktop");
            jxi = fOm.OkB();
        }
    }
}

